/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.CompositionCreator;
import com.twilio.rest.video.v1.CompositionDeleter;
import com.twilio.rest.video.v1.CompositionFetcher;
import com.twilio.rest.video.v1.CompositionReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Composition
extends Resource {
    private static final long serialVersionUID = 61658716109908L;
    private final String accountSid;
    private final Status status;
    private final DateTime dateCreated;
    private final DateTime dateCompleted;
    private final DateTime dateDeleted;
    private final String sid;
    private final String roomSid;
    private final List<String> audioSources;
    private final List<String> audioSourcesExcluded;
    private final Map<String, Object> videoLayout;
    private final String resolution;
    private final Boolean trim;
    private final Format format;
    private final Integer bitrate;
    private final Long size;
    private final Integer duration;
    private final URI url;
    private final Map<String, String> links;

    public static CompositionFetcher fetcher(String pathSid) {
        return new CompositionFetcher(pathSid);
    }

    public static CompositionReader reader() {
        return new CompositionReader();
    }

    public static CompositionDeleter deleter(String pathSid) {
        return new CompositionDeleter(pathSid);
    }

    public static CompositionCreator creator(String roomSid) {
        return new CompositionCreator(roomSid);
    }

    public static Composition fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Composition.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Composition fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Composition.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Composition(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="status") Status status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_completed") String dateCompleted, @JsonProperty(value="date_deleted") String dateDeleted, @JsonProperty(value="sid") String sid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="audio_sources") List<String> audioSources, @JsonProperty(value="audio_sources_excluded") List<String> audioSourcesExcluded, @JsonProperty(value="video_layout") Map<String, Object> videoLayout, @JsonProperty(value="resolution") String resolution, @JsonProperty(value="trim") Boolean trim, @JsonProperty(value="format") Format format, @JsonProperty(value="bitrate") Integer bitrate, @JsonProperty(value="size") Long size, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateCompleted = DateConverter.iso8601DateTimeFromString(dateCompleted);
        this.dateDeleted = DateConverter.iso8601DateTimeFromString(dateDeleted);
        this.sid = sid;
        this.roomSid = roomSid;
        this.audioSources = audioSources;
        this.audioSourcesExcluded = audioSourcesExcluded;
        this.videoLayout = videoLayout;
        this.resolution = resolution;
        this.trim = trim;
        this.format = format;
        this.bitrate = bitrate;
        this.size = size;
        this.duration = duration;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateCompleted() {
        return this.dateCompleted;
    }

    public final DateTime getDateDeleted() {
        return this.dateDeleted;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final List<String> getAudioSources() {
        return this.audioSources;
    }

    public final List<String> getAudioSourcesExcluded() {
        return this.audioSourcesExcluded;
    }

    public final Map<String, Object> getVideoLayout() {
        return this.videoLayout;
    }

    public final String getResolution() {
        return this.resolution;
    }

    public final Boolean getTrim() {
        return this.trim;
    }

    public final Format getFormat() {
        return this.format;
    }

    public final Integer getBitrate() {
        return this.bitrate;
    }

    public final Long getSize() {
        return this.size;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Composition other = (Composition)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateCompleted, other.dateCompleted) && Objects.equals(this.dateDeleted, other.dateDeleted) && Objects.equals(this.sid, other.sid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.audioSources, other.audioSources) && Objects.equals(this.audioSourcesExcluded, other.audioSourcesExcluded) && Objects.equals(this.videoLayout, other.videoLayout) && Objects.equals(this.resolution, other.resolution) && Objects.equals(this.trim, other.trim) && Objects.equals((Object)this.format, (Object)other.format) && Objects.equals(this.bitrate, other.bitrate) && Objects.equals(this.size, other.size) && Objects.equals(this.duration, other.duration) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.status, this.dateCreated, this.dateCompleted, this.dateDeleted, this.sid, this.roomSid, this.audioSources, this.audioSourcesExcluded, this.videoLayout, this.resolution, this.trim, this.format, this.bitrate, this.size, this.duration, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("status", (Object)this.status).add("dateCreated", this.dateCreated).add("dateCompleted", this.dateCompleted).add("dateDeleted", this.dateDeleted).add("sid", this.sid).add("roomSid", this.roomSid).add("audioSources", this.audioSources).add("audioSourcesExcluded", this.audioSourcesExcluded).add("videoLayout", this.videoLayout).add("resolution", this.resolution).add("trim", this.trim).add("format", (Object)this.format).add("bitrate", this.bitrate).add("size", this.size).add("duration", this.duration).add("url", this.url).add("links", this.links).toString();
    }

    public static enum Format {
        MP4("mp4"),
        WEBM("webm");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Format forValue(String value) {
            return (Format)Promoter.enumFromString((String)value, (Enum[])Format.values());
        }
    }

    public static enum Status {
        ENQUEUED("enqueued"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        DELETED("deleted"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

