/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.Composition;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class CompositionCreator
extends Creator<Composition> {
    private final String roomSid;
    private Map<String, Object> videoLayout;
    private List<String> audioSources;
    private List<String> audioSourcesExcluded;
    private String resolution;
    private Composition.Format format;
    private URI statusCallback;
    private HttpMethod statusCallbackMethod;
    private Boolean trim;

    public CompositionCreator(String roomSid) {
        this.roomSid = roomSid;
    }

    public CompositionCreator setVideoLayout(Map<String, Object> videoLayout) {
        this.videoLayout = videoLayout;
        return this;
    }

    public CompositionCreator setAudioSources(List<String> audioSources) {
        this.audioSources = audioSources;
        return this;
    }

    public CompositionCreator setAudioSources(String audioSources) {
        return this.setAudioSources(Promoter.listOfOne(audioSources));
    }

    public CompositionCreator setAudioSourcesExcluded(List<String> audioSourcesExcluded) {
        this.audioSourcesExcluded = audioSourcesExcluded;
        return this;
    }

    public CompositionCreator setAudioSourcesExcluded(String audioSourcesExcluded) {
        return this.setAudioSourcesExcluded(Promoter.listOfOne(audioSourcesExcluded));
    }

    public CompositionCreator setResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public CompositionCreator setFormat(Composition.Format format) {
        this.format = format;
        return this;
    }

    public CompositionCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public CompositionCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public CompositionCreator setStatusCallbackMethod(HttpMethod statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public CompositionCreator setTrim(Boolean trim) {
        this.trim = trim;
        return this;
    }

    @Override
    public Composition create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/Compositions", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Composition creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Composition.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.roomSid != null) {
            request.addPostParam("RoomSid", this.roomSid);
        }
        if (this.videoLayout != null) {
            request.addPostParam("VideoLayout", Converter.mapToJson(this.videoLayout));
        }
        if (this.audioSources != null) {
            for (String prop : this.audioSources) {
                request.addPostParam("AudioSources", prop);
            }
        }
        if (this.audioSourcesExcluded != null) {
            for (String prop : this.audioSourcesExcluded) {
                request.addPostParam("AudioSourcesExcluded", prop);
            }
        }
        if (this.resolution != null) {
            request.addPostParam("Resolution", this.resolution);
        }
        if (this.format != null) {
            request.addPostParam("Format", this.format.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.statusCallbackMethod != null) {
            request.addPostParam("StatusCallbackMethod", this.statusCallbackMethod.toString());
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim.toString());
        }
    }
}

