/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.dialingpermissions.BulkCountryUpdate;

public class BulkCountryUpdateCreator
extends Creator<BulkCountryUpdate> {
    private final String updateRequest;

    public BulkCountryUpdateCreator(String updateRequest) {
        this.updateRequest = updateRequest;
    }

    @Override
    public BulkCountryUpdate create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), "/v1/DialingPermissions/BulkCountryUpdates", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BulkCountryUpdate creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return BulkCountryUpdate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.updateRequest != null) {
            request.addPostParam("UpdateRequest", this.updateRequest);
        }
    }
}

