/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.dialingpermissions.CountryFetcher;
import com.twilio.rest.voice.v1.dialingpermissions.CountryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Country
extends Resource {
    private static final long serialVersionUID = 83622253964242L;
    private final String isoCode;
    private final String name;
    private final String continent;
    private final List<String> countryCodes;
    private final Boolean lowRiskNumbersEnabled;
    private final Boolean highRiskSpecialNumbersEnabled;
    private final Boolean highRiskTollfraudNumbersEnabled;
    private final URI url;
    private final Map<String, String> links;

    public static CountryFetcher fetcher(String pathIsoCode) {
        return new CountryFetcher(pathIsoCode);
    }

    public static CountryReader reader() {
        return new CountryReader();
    }

    public static Country fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Country fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Country.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Country(@JsonProperty(value="iso_code") String isoCode, @JsonProperty(value="name") String name, @JsonProperty(value="continent") String continent, @JsonProperty(value="country_codes") List<String> countryCodes, @JsonProperty(value="low_risk_numbers_enabled") Boolean lowRiskNumbersEnabled, @JsonProperty(value="high_risk_special_numbers_enabled") Boolean highRiskSpecialNumbersEnabled, @JsonProperty(value="high_risk_tollfraud_numbers_enabled") Boolean highRiskTollfraudNumbersEnabled, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.isoCode = isoCode;
        this.name = name;
        this.continent = continent;
        this.countryCodes = countryCodes;
        this.lowRiskNumbersEnabled = lowRiskNumbersEnabled;
        this.highRiskSpecialNumbersEnabled = highRiskSpecialNumbersEnabled;
        this.highRiskTollfraudNumbersEnabled = highRiskTollfraudNumbersEnabled;
        this.url = url;
        this.links = links;
    }

    public final String getIsoCode() {
        return this.isoCode;
    }

    public final String getName() {
        return this.name;
    }

    public final String getContinent() {
        return this.continent;
    }

    public final List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public final Boolean getLowRiskNumbersEnabled() {
        return this.lowRiskNumbersEnabled;
    }

    public final Boolean getHighRiskSpecialNumbersEnabled() {
        return this.highRiskSpecialNumbersEnabled;
    }

    public final Boolean getHighRiskTollfraudNumbersEnabled() {
        return this.highRiskTollfraudNumbersEnabled;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Country other = (Country)o;
        return Objects.equals(this.isoCode, other.isoCode) && Objects.equals(this.name, other.name) && Objects.equals(this.continent, other.continent) && Objects.equals(this.countryCodes, other.countryCodes) && Objects.equals(this.lowRiskNumbersEnabled, other.lowRiskNumbersEnabled) && Objects.equals(this.highRiskSpecialNumbersEnabled, other.highRiskSpecialNumbersEnabled) && Objects.equals(this.highRiskTollfraudNumbersEnabled, other.highRiskTollfraudNumbersEnabled) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.isoCode, this.name, this.continent, this.countryCodes, this.lowRiskNumbersEnabled, this.highRiskSpecialNumbersEnabled, this.highRiskTollfraudNumbersEnabled, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("isoCode", this.isoCode).add("name", this.name).add("continent", this.continent).add("countryCodes", this.countryCodes).add("lowRiskNumbersEnabled", this.lowRiskNumbersEnabled).add("highRiskSpecialNumbersEnabled", this.highRiskSpecialNumbersEnabled).add("highRiskTollfraudNumbersEnabled", this.highRiskTollfraudNumbersEnabled).add("url", this.url).add("links", this.links).toString();
    }
}

