/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.dialingpermissions.Country;

public class CountryFetcher
extends Fetcher<Country> {
    private final String pathIsoCode;

    public CountryFetcher(String pathIsoCode) {
        this.pathIsoCode = pathIsoCode;
    }

    @Override
    public Country fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VOICE.toString(), "/v1/DialingPermissions/Countries/" + this.pathIsoCode + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Country.fromJson(response.getStream(), client.getObjectMapper());
    }
}

