/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.wireless.v1.RatePlanCreator;
import com.twilio.rest.wireless.v1.RatePlanDeleter;
import com.twilio.rest.wireless.v1.RatePlanFetcher;
import com.twilio.rest.wireless.v1.RatePlanReader;
import com.twilio.rest.wireless.v1.RatePlanUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RatePlan
extends Resource {
    private static final long serialVersionUID = 187833777753811L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final String friendlyName;
    private final Boolean dataEnabled;
    private final String dataMetering;
    private final Integer dataLimit;
    private final Boolean messagingEnabled;
    private final Boolean voiceEnabled;
    private final Boolean nationalRoamingEnabled;
    private final Integer nationalRoamingDataLimit;
    private final List<String> internationalRoaming;
    private final Integer internationalRoamingDataLimit;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static RatePlanReader reader() {
        return new RatePlanReader();
    }

    public static RatePlanFetcher fetcher(String pathSid) {
        return new RatePlanFetcher(pathSid);
    }

    public static RatePlanCreator creator() {
        return new RatePlanCreator();
    }

    public static RatePlanUpdater updater(String pathSid) {
        return new RatePlanUpdater(pathSid);
    }

    public static RatePlanDeleter deleter(String pathSid) {
        return new RatePlanDeleter(pathSid);
    }

    public static RatePlan fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RatePlan.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RatePlan fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RatePlan.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RatePlan(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="data_enabled") Boolean dataEnabled, @JsonProperty(value="data_metering") String dataMetering, @JsonProperty(value="data_limit") Integer dataLimit, @JsonProperty(value="messaging_enabled") Boolean messagingEnabled, @JsonProperty(value="voice_enabled") Boolean voiceEnabled, @JsonProperty(value="national_roaming_enabled") Boolean nationalRoamingEnabled, @JsonProperty(value="national_roaming_data_limit") Integer nationalRoamingDataLimit, @JsonProperty(value="international_roaming") List<String> internationalRoaming, @JsonProperty(value="international_roaming_data_limit") Integer internationalRoamingDataLimit, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dataEnabled = dataEnabled;
        this.dataMetering = dataMetering;
        this.dataLimit = dataLimit;
        this.messagingEnabled = messagingEnabled;
        this.voiceEnabled = voiceEnabled;
        this.nationalRoamingEnabled = nationalRoamingEnabled;
        this.nationalRoamingDataLimit = nationalRoamingDataLimit;
        this.internationalRoaming = internationalRoaming;
        this.internationalRoamingDataLimit = internationalRoamingDataLimit;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Boolean getDataEnabled() {
        return this.dataEnabled;
    }

    public final String getDataMetering() {
        return this.dataMetering;
    }

    public final Integer getDataLimit() {
        return this.dataLimit;
    }

    public final Boolean getMessagingEnabled() {
        return this.messagingEnabled;
    }

    public final Boolean getVoiceEnabled() {
        return this.voiceEnabled;
    }

    public final Boolean getNationalRoamingEnabled() {
        return this.nationalRoamingEnabled;
    }

    public final Integer getNationalRoamingDataLimit() {
        return this.nationalRoamingDataLimit;
    }

    public final List<String> getInternationalRoaming() {
        return this.internationalRoaming;
    }

    public final Integer getInternationalRoamingDataLimit() {
        return this.internationalRoamingDataLimit;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatePlan other = (RatePlan)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dataEnabled, other.dataEnabled) && Objects.equals(this.dataMetering, other.dataMetering) && Objects.equals(this.dataLimit, other.dataLimit) && Objects.equals(this.messagingEnabled, other.messagingEnabled) && Objects.equals(this.voiceEnabled, other.voiceEnabled) && Objects.equals(this.nationalRoamingEnabled, other.nationalRoamingEnabled) && Objects.equals(this.nationalRoamingDataLimit, other.nationalRoamingDataLimit) && Objects.equals(this.internationalRoaming, other.internationalRoaming) && Objects.equals(this.internationalRoamingDataLimit, other.internationalRoamingDataLimit) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.uniqueName, this.accountSid, this.friendlyName, this.dataEnabled, this.dataMetering, this.dataLimit, this.messagingEnabled, this.voiceEnabled, this.nationalRoamingEnabled, this.nationalRoamingDataLimit, this.internationalRoaming, this.internationalRoamingDataLimit, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("uniqueName", this.uniqueName).add("accountSid", this.accountSid).add("friendlyName", this.friendlyName).add("dataEnabled", this.dataEnabled).add("dataMetering", this.dataMetering).add("dataLimit", this.dataLimit).add("messagingEnabled", this.messagingEnabled).add("voiceEnabled", this.voiceEnabled).add("nationalRoamingEnabled", this.nationalRoamingEnabled).add("nationalRoamingDataLimit", this.nationalRoamingDataLimit).add("internationalRoaming", this.internationalRoaming).add("internationalRoamingDataLimit", this.internationalRoamingDataLimit).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }
}

