/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.Sim;
import java.net.URI;

public class SimUpdater
extends Updater<Sim> {
    private final String pathSid;
    private String uniqueName;
    private HttpMethod callbackMethod;
    private URI callbackUrl;
    private String friendlyName;
    private String ratePlan;
    private Sim.Status status;
    private HttpMethod commandsCallbackMethod;
    private URI commandsCallbackUrl;
    private HttpMethod smsFallbackMethod;
    private URI smsFallbackUrl;
    private HttpMethod smsMethod;
    private URI smsUrl;
    private HttpMethod voiceFallbackMethod;
    private URI voiceFallbackUrl;
    private HttpMethod voiceMethod;
    private URI voiceUrl;
    private Sim.ResetStatus resetStatus;

    public SimUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public SimUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public SimUpdater setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public SimUpdater setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public SimUpdater setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public SimUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public SimUpdater setRatePlan(String ratePlan) {
        this.ratePlan = ratePlan;
        return this;
    }

    public SimUpdater setStatus(Sim.Status status) {
        this.status = status;
        return this;
    }

    public SimUpdater setCommandsCallbackMethod(HttpMethod commandsCallbackMethod) {
        this.commandsCallbackMethod = commandsCallbackMethod;
        return this;
    }

    public SimUpdater setCommandsCallbackUrl(URI commandsCallbackUrl) {
        this.commandsCallbackUrl = commandsCallbackUrl;
        return this;
    }

    public SimUpdater setCommandsCallbackUrl(String commandsCallbackUrl) {
        return this.setCommandsCallbackUrl(Promoter.uriFromString(commandsCallbackUrl));
    }

    public SimUpdater setSmsFallbackMethod(HttpMethod smsFallbackMethod) {
        this.smsFallbackMethod = smsFallbackMethod;
        return this;
    }

    public SimUpdater setSmsFallbackUrl(URI smsFallbackUrl) {
        this.smsFallbackUrl = smsFallbackUrl;
        return this;
    }

    public SimUpdater setSmsFallbackUrl(String smsFallbackUrl) {
        return this.setSmsFallbackUrl(Promoter.uriFromString(smsFallbackUrl));
    }

    public SimUpdater setSmsMethod(HttpMethod smsMethod) {
        this.smsMethod = smsMethod;
        return this;
    }

    public SimUpdater setSmsUrl(URI smsUrl) {
        this.smsUrl = smsUrl;
        return this;
    }

    public SimUpdater setSmsUrl(String smsUrl) {
        return this.setSmsUrl(Promoter.uriFromString(smsUrl));
    }

    public SimUpdater setVoiceFallbackMethod(HttpMethod voiceFallbackMethod) {
        this.voiceFallbackMethod = voiceFallbackMethod;
        return this;
    }

    public SimUpdater setVoiceFallbackUrl(URI voiceFallbackUrl) {
        this.voiceFallbackUrl = voiceFallbackUrl;
        return this;
    }

    public SimUpdater setVoiceFallbackUrl(String voiceFallbackUrl) {
        return this.setVoiceFallbackUrl(Promoter.uriFromString(voiceFallbackUrl));
    }

    public SimUpdater setVoiceMethod(HttpMethod voiceMethod) {
        this.voiceMethod = voiceMethod;
        return this;
    }

    public SimUpdater setVoiceUrl(URI voiceUrl) {
        this.voiceUrl = voiceUrl;
        return this;
    }

    public SimUpdater setVoiceUrl(String voiceUrl) {
        return this.setVoiceUrl(Promoter.uriFromString(voiceUrl));
    }

    public SimUpdater setResetStatus(Sim.ResetStatus resetStatus) {
        this.resetStatus = resetStatus;
        return this;
    }

    @Override
    public Sim update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.WIRELESS.toString(), "/v1/Sims/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sim update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Sim.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.ratePlan != null) {
            request.addPostParam("RatePlan", this.ratePlan.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.commandsCallbackMethod != null) {
            request.addPostParam("CommandsCallbackMethod", this.commandsCallbackMethod.toString());
        }
        if (this.commandsCallbackUrl != null) {
            request.addPostParam("CommandsCallbackUrl", this.commandsCallbackUrl.toString());
        }
        if (this.smsFallbackMethod != null) {
            request.addPostParam("SmsFallbackMethod", this.smsFallbackMethod.toString());
        }
        if (this.smsFallbackUrl != null) {
            request.addPostParam("SmsFallbackUrl", this.smsFallbackUrl.toString());
        }
        if (this.smsMethod != null) {
            request.addPostParam("SmsMethod", this.smsMethod.toString());
        }
        if (this.smsUrl != null) {
            request.addPostParam("SmsUrl", this.smsUrl.toString());
        }
        if (this.voiceFallbackMethod != null) {
            request.addPostParam("VoiceFallbackMethod", this.voiceFallbackMethod.toString());
        }
        if (this.voiceFallbackUrl != null) {
            request.addPostParam("VoiceFallbackUrl", this.voiceFallbackUrl.toString());
        }
        if (this.voiceMethod != null) {
            request.addPostParam("VoiceMethod", this.voiceMethod.toString());
        }
        if (this.voiceUrl != null) {
            request.addPostParam("VoiceUrl", this.voiceUrl.toString());
        }
        if (this.resetStatus != null) {
            request.addPostParam("ResetStatus", this.resetStatus.toString());
        }
    }
}

