/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.Pause;
import com.twilio.twiml.voice.Play;
import com.twilio.twiml.voice.Say;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Gather
extends TwiML {
    private final List<Input> input;
    private final URI action;
    private final HttpMethod method;
    private final Integer timeout;
    private final String speechTimeout;
    private final Integer maxSpeechTime;
    private final Boolean profanityFilter;
    private final String finishOnKey;
    private final Integer numDigits;
    private final URI partialResultCallback;
    private final HttpMethod partialResultCallbackMethod;
    private final Language language;
    private final String hints;
    private final Boolean bargeIn;
    private final Boolean debug;
    private final Boolean actionOnEmptyResult;

    private Gather() {
        this(new Builder());
    }

    private Gather(Builder b) {
        super("Gather", b);
        this.input = b.input;
        this.action = b.action;
        this.method = b.method;
        this.timeout = b.timeout;
        this.speechTimeout = b.speechTimeout;
        this.maxSpeechTime = b.maxSpeechTime;
        this.profanityFilter = b.profanityFilter;
        this.finishOnKey = b.finishOnKey;
        this.numDigits = b.numDigits;
        this.partialResultCallback = b.partialResultCallback;
        this.partialResultCallbackMethod = b.partialResultCallbackMethod;
        this.language = b.language;
        this.hints = b.hints;
        this.bargeIn = b.bargeIn;
        this.debug = b.debug;
        this.actionOnEmptyResult = b.actionOnEmptyResult;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getInputs() != null) {
            attrs.put("input", this.getInputsAsString());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getSpeechTimeout() != null) {
            attrs.put("speechTimeout", this.getSpeechTimeout());
        }
        if (this.getMaxSpeechTime() != null) {
            attrs.put("maxSpeechTime", this.getMaxSpeechTime().toString());
        }
        if (this.isProfanityFilter() != null) {
            attrs.put("profanityFilter", this.isProfanityFilter().toString());
        }
        if (this.getFinishOnKey() != null) {
            attrs.put("finishOnKey", this.getFinishOnKey());
        }
        if (this.getNumDigits() != null) {
            attrs.put("numDigits", this.getNumDigits().toString());
        }
        if (this.getPartialResultCallback() != null) {
            attrs.put("partialResultCallback", this.getPartialResultCallback().toString());
        }
        if (this.getPartialResultCallbackMethod() != null) {
            attrs.put("partialResultCallbackMethod", this.getPartialResultCallbackMethod().toString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        if (this.getHints() != null) {
            attrs.put("hints", this.getHints());
        }
        if (this.isBargeIn() != null) {
            attrs.put("bargeIn", this.isBargeIn().toString());
        }
        if (this.isDebug() != null) {
            attrs.put("debug", this.isDebug().toString());
        }
        if (this.isActionOnEmptyResult() != null) {
            attrs.put("actionOnEmptyResult", this.isActionOnEmptyResult().toString());
        }
        return attrs;
    }

    public List<Input> getInputs() {
        return this.input;
    }

    protected String getInputsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Input> iter = this.getInputs().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getSpeechTimeout() {
        return this.speechTimeout;
    }

    public Integer getMaxSpeechTime() {
        return this.maxSpeechTime;
    }

    public Boolean isProfanityFilter() {
        return this.profanityFilter;
    }

    public String getFinishOnKey() {
        return this.finishOnKey;
    }

    public Integer getNumDigits() {
        return this.numDigits;
    }

    public URI getPartialResultCallback() {
        return this.partialResultCallback;
    }

    public HttpMethod getPartialResultCallbackMethod() {
        return this.partialResultCallbackMethod;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getHints() {
        return this.hints;
    }

    public Boolean isBargeIn() {
        return this.bargeIn;
    }

    public Boolean isDebug() {
        return this.debug;
    }

    public Boolean isActionOnEmptyResult() {
        return this.actionOnEmptyResult;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private List<Input> input;
        private URI action;
        private HttpMethod method;
        private Integer timeout;
        private String speechTimeout;
        private Integer maxSpeechTime;
        private Boolean profanityFilter;
        private String finishOnKey;
        private Integer numDigits;
        private URI partialResultCallback;
        private HttpMethod partialResultCallbackMethod;
        private Language language;
        private String hints;
        private Boolean bargeIn;
        private Boolean debug;
        private Boolean actionOnEmptyResult;

        public Builder inputs(List<Input> input) {
            this.input = input;
            return this;
        }

        public Builder inputs(Input input) {
            this.input = Promoter.listOfOne(input);
            return this;
        }

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder speechTimeout(String speechTimeout) {
            this.speechTimeout = speechTimeout;
            return this;
        }

        public Builder maxSpeechTime(Integer maxSpeechTime) {
            this.maxSpeechTime = maxSpeechTime;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder finishOnKey(String finishOnKey) {
            this.finishOnKey = finishOnKey;
            return this;
        }

        public Builder numDigits(Integer numDigits) {
            this.numDigits = numDigits;
            return this;
        }

        public Builder partialResultCallback(URI partialResultCallback) {
            this.partialResultCallback = partialResultCallback;
            return this;
        }

        public Builder partialResultCallback(String partialResultCallback) {
            this.partialResultCallback = Promoter.uriFromString(partialResultCallback);
            return this;
        }

        public Builder partialResultCallbackMethod(HttpMethod partialResultCallbackMethod) {
            this.partialResultCallbackMethod = partialResultCallbackMethod;
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder hints(String hints) {
            this.hints = hints;
            return this;
        }

        public Builder bargeIn(Boolean bargeIn) {
            this.bargeIn = bargeIn;
            return this;
        }

        public Builder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder actionOnEmptyResult(Boolean actionOnEmptyResult) {
            this.actionOnEmptyResult = actionOnEmptyResult;
            return this;
        }

        public Builder say(Say say) {
            this.children.add(say);
            return this;
        }

        public Builder pause(Pause pause) {
            this.children.add(pause);
            return this;
        }

        public Builder play(Play play) {
            this.children.add(play);
            return this;
        }

        public Gather build() {
            return new Gather(this);
        }
    }

    public static enum Language {
        AF_ZA("af-ZA"),
        AM_ET("am-ET"),
        HY_AM("hy-AM"),
        AZ_AZ("az-AZ"),
        ID_ID("id-ID"),
        MS_MY("ms-MY"),
        BN_BD("bn-BD"),
        BN_IN("bn-IN"),
        CA_ES("ca-ES"),
        CS_CZ("cs-CZ"),
        DA_DK("da-DK"),
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GH("en-GH"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_KE("en-KE"),
        EN_NZ("en-NZ"),
        EN_NG("en-NG"),
        EN_PH("en-PH"),
        EN_ZA("en-ZA"),
        EN_TZ("en-TZ"),
        EN_US("en-US"),
        ES_AR("es-AR"),
        ES_BO("es-BO"),
        ES_CL("es-CL"),
        ES_CO("es-CO"),
        ES_CR("es-CR"),
        ES_EC("es-EC"),
        ES_SV("es-SV"),
        ES_ES("es-ES"),
        ES_US("es-US"),
        ES_GT("es-GT"),
        ES_HN("es-HN"),
        ES_MX("es-MX"),
        ES_NI("es-NI"),
        ES_PA("es-PA"),
        ES_PY("es-PY"),
        ES_PE("es-PE"),
        ES_PR("es-PR"),
        ES_DO("es-DO"),
        ES_UY("es-UY"),
        ES_VE("es-VE"),
        EU_ES("eu-ES"),
        FIL_PH("fil-PH"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        GL_ES("gl-ES"),
        KA_GE("ka-GE"),
        GU_IN("gu-IN"),
        HR_HR("hr-HR"),
        ZU_ZA("zu-ZA"),
        IS_IS("is-IS"),
        IT_IT("it-IT"),
        JV_ID("jv-ID"),
        KN_IN("kn-IN"),
        KM_KH("km-KH"),
        LO_LA("lo-LA"),
        LV_LV("lv-LV"),
        LT_LT("lt-LT"),
        HU_HU("hu-HU"),
        ML_IN("ml-IN"),
        MR_IN("mr-IN"),
        NL_NL("nl-NL"),
        NE_NP("ne-NP"),
        NB_NO("nb-NO"),
        PL_PL("pl-PL"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        RO_RO("ro-RO"),
        SI_LK("si-LK"),
        SK_SK("sk-SK"),
        SL_SI("sl-SI"),
        SU_ID("su-ID"),
        SW_TZ("sw-TZ"),
        SW_KE("sw-KE"),
        FI_FI("fi-FI"),
        SV_SE("sv-SE"),
        TA_IN("ta-IN"),
        TA_SG("ta-SG"),
        TA_LK("ta-LK"),
        TA_MY("ta-MY"),
        TE_IN("te-IN"),
        VI_VN("vi-VN"),
        TR_TR("tr-TR"),
        UR_PK("ur-PK"),
        UR_IN("ur-IN"),
        EL_GR("el-GR"),
        BG_BG("bg-BG"),
        RU_RU("ru-RU"),
        SR_RS("sr-RS"),
        UK_UA("uk-UA"),
        HE_IL("he-IL"),
        AR_IL("ar-IL"),
        AR_JO("ar-JO"),
        AR_AE("ar-AE"),
        AR_BH("ar-BH"),
        AR_DZ("ar-DZ"),
        AR_SA("ar-SA"),
        AR_IQ("ar-IQ"),
        AR_KW("ar-KW"),
        AR_MA("ar-MA"),
        AR_TN("ar-TN"),
        AR_OM("ar-OM"),
        AR_PS("ar-PS"),
        AR_QA("ar-QA"),
        AR_LB("ar-LB"),
        AR_EG("ar-EG"),
        FA_IR("fa-IR"),
        HI_IN("hi-IN"),
        TH_TH("th-TH"),
        KO_KR("ko-KR"),
        CMN_HANT_TW("cmn-Hant-TW"),
        YUE_HANT_HK("yue-Hant-HK"),
        JA_JP("ja-JP"),
        CMN_HANS_HK("cmn-Hans-HK"),
        CMN_HANS_CN("cmn-Hans-CN");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Input {
        DTMF("dtmf"),
        SPEECH("speech");

        private final String value;

        private Input(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

