/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.Parameter;
import com.twilio.twiml.voice.Prompt;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Pay
extends TwiML {
    private final Input input;
    private final URI action;
    private final BankAccountType bankAccountType;
    private final URI statusCallback;
    private final StatusCallbackMethod statusCallbackMethod;
    private final Integer timeout;
    private final Integer maxAttempts;
    private final Boolean securityCode;
    private final String postalCode;
    private final Integer minPostalCodeLength;
    private final String paymentConnector;
    private final PaymentMethod paymentMethod;
    private final TokenType tokenType;
    private final String chargeAmount;
    private final String currency;
    private final String description;
    private final List<ValidCardTypes> validCardTypes;
    private final Language language;

    private Pay() {
        this(new Builder());
    }

    private Pay(Builder b) {
        super("Pay", b);
        this.input = b.input;
        this.action = b.action;
        this.bankAccountType = b.bankAccountType;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.timeout = b.timeout;
        this.maxAttempts = b.maxAttempts;
        this.securityCode = b.securityCode;
        this.postalCode = b.postalCode;
        this.minPostalCodeLength = b.minPostalCodeLength;
        this.paymentConnector = b.paymentConnector;
        this.paymentMethod = b.paymentMethod;
        this.tokenType = b.tokenType;
        this.chargeAmount = b.chargeAmount;
        this.currency = b.currency;
        this.description = b.description;
        this.validCardTypes = b.validCardTypes;
        this.language = b.language;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getInput() != null) {
            attrs.put("input", this.getInput().toString());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getBankAccountType() != null) {
            attrs.put("bankAccountType", this.getBankAccountType().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        if (this.getMaxAttempts() != null) {
            attrs.put("maxAttempts", this.getMaxAttempts().toString());
        }
        if (this.isSecurityCode() != null) {
            attrs.put("securityCode", this.isSecurityCode().toString());
        }
        if (this.getPostalCode() != null) {
            attrs.put("postalCode", this.getPostalCode());
        }
        if (this.getMinPostalCodeLength() != null) {
            attrs.put("minPostalCodeLength", this.getMinPostalCodeLength().toString());
        }
        if (this.getPaymentConnector() != null) {
            attrs.put("paymentConnector", this.getPaymentConnector());
        }
        if (this.getPaymentMethod() != null) {
            attrs.put("paymentMethod", this.getPaymentMethod().toString());
        }
        if (this.getTokenType() != null) {
            attrs.put("tokenType", this.getTokenType().toString());
        }
        if (this.getChargeAmount() != null) {
            attrs.put("chargeAmount", this.getChargeAmount());
        }
        if (this.getCurrency() != null) {
            attrs.put("currency", this.getCurrency());
        }
        if (this.getDescription() != null) {
            attrs.put("description", this.getDescription());
        }
        if (this.getValidCardTypess() != null) {
            attrs.put("validCardTypes", this.getValidCardTypessAsString());
        }
        if (this.getLanguage() != null) {
            attrs.put("language", this.getLanguage().toString());
        }
        return attrs;
    }

    public Input getInput() {
        return this.input;
    }

    public URI getAction() {
        return this.action;
    }

    public BankAccountType getBankAccountType() {
        return this.bankAccountType;
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public StatusCallbackMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public Boolean isSecurityCode() {
        return this.securityCode;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public Integer getMinPostalCodeLength() {
        return this.minPostalCodeLength;
    }

    public String getPaymentConnector() {
        return this.paymentConnector;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getChargeAmount() {
        return this.chargeAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ValidCardTypes> getValidCardTypess() {
        return this.validCardTypes;
    }

    protected String getValidCardTypessAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<ValidCardTypes> iter = this.getValidCardTypess().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public Language getLanguage() {
        return this.language;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private Input input;
        private URI action;
        private BankAccountType bankAccountType;
        private URI statusCallback;
        private StatusCallbackMethod statusCallbackMethod;
        private Integer timeout;
        private Integer maxAttempts;
        private Boolean securityCode;
        private String postalCode;
        private Integer minPostalCodeLength;
        private String paymentConnector;
        private PaymentMethod paymentMethod;
        private TokenType tokenType;
        private String chargeAmount;
        private String currency;
        private String description;
        private List<ValidCardTypes> validCardTypes;
        private Language language;

        public Builder input(Input input) {
            this.input = input;
            return this;
        }

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder bankAccountType(BankAccountType bankAccountType) {
            this.bankAccountType = bankAccountType;
            return this;
        }

        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        public Builder statusCallbackMethod(StatusCallbackMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder securityCode(Boolean securityCode) {
            this.securityCode = securityCode;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder minPostalCodeLength(Integer minPostalCodeLength) {
            this.minPostalCodeLength = minPostalCodeLength;
            return this;
        }

        public Builder paymentConnector(String paymentConnector) {
            this.paymentConnector = paymentConnector;
            return this;
        }

        public Builder paymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder chargeAmount(String chargeAmount) {
            this.chargeAmount = chargeAmount;
            return this;
        }

        public Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder validCardTypes(List<ValidCardTypes> validCardTypes) {
            this.validCardTypes = validCardTypes;
            return this;
        }

        public Builder validCardTypes(ValidCardTypes validCardTypes) {
            this.validCardTypes = Promoter.listOfOne(validCardTypes);
            return this;
        }

        public Builder language(Language language) {
            this.language = language;
            return this;
        }

        public Builder prompt(Prompt prompt) {
            this.children.add(prompt);
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public Pay build() {
            return new Pay(this);
        }
    }

    public static enum PaymentMethod {
        ACH_DEBIT("ach-debit"),
        CREDIT_CARD("credit-card");

        private final String value;

        private PaymentMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum BankAccountType {
        CONSUMER_CHECKING("consumer-checking"),
        CONSUMER_SAVINGS("consumer-savings"),
        COMMERCIAL_CHECKING("commercial-checking"),
        COMMERCIAL_SAVINGS("commercial-savings");

        private final String value;

        private BankAccountType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Language {
        DE_DE("de-DE"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_ZA("en-ZA"),
        EN_US("en-US"),
        ES_ES("es-ES"),
        ES_US("es-US"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        IT_IT("it-IT");

        private final String value;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ValidCardTypes {
        VISA("visa"),
        MASTERCARD("mastercard"),
        AMEX("amex"),
        MAESTRO("maestro"),
        DISCOVER("discover"),
        OPTIMA("optima"),
        JCB("jcb"),
        DINERS_CLUB("diners-club"),
        ENROUTE("enroute");

        private final String value;

        private ValidCardTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TokenType {
        ONE_TIME("one-time"),
        REUSABLE("reusable");

        private final String value;

        private TokenType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum StatusCallbackMethod {
        GET("GET"),
        POST("POST");

        private final String value;

        private StatusCallbackMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Input {
        DTMF("dtmf");

        private final String value;

        private Input(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

