/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.msserialconnection;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import io.github.pieter12345.msserialconnection.MSSerialConnection;
import io.github.pieter12345.msserialconnection.SerialDataReceivedEvent;
import io.github.pieter12345.msserialconnection.exceptions.CRE.CREIllegalStateException;
import io.github.pieter12345.msserialconnection.exceptions.CRE.CRESerialPortException;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class SerialConnectionFunctions {
    public static String docs() {
        return "Provides serial connection API that can be used to communicate with serial devices through COMPORT/USB.";
    }

    public static abstract class SerialConnectionFunction
    extends AbstractFunction {
        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public boolean isRestricted() {
            return false;
        }

        public Boolean runAsync() {
            return true;
        }

        public Version since() {
            return MSVersion.V3_3_4;
        }
    }

    @api
    public static class serial_send
    extends SerialConnectionFunction {
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        public String docs() {
            return "void {string serialPort, byte_array data} Sends the given data to the given serial connection. Throws IllegalStateException when the given serial port was not open. Throws SerialPortException when sending the data to the serial port fails.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalStateException.class, CRESerialPortException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            CByteArray data = ArgumentValidation.getByteArray((Mixed)args[1], (Target)t);
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.get(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port was not opened.", t);
            }
            try {
                if (!serialPort.writeBytes(data.asByteArrayCopy())) {
                    throw new CRESerialPortException(serialPort, "Failed to send data to serial port.", t);
                }
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_disconnect
    extends SerialConnectionFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "void {string portName} Disconnects from the given serial port. Throws an IllegalStateException when the given serial port was not open.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalStateException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            SerialPort serialPort = MSSerialConnection.SERIAL_CONNECTIONS.remove(portName);
            if (serialPort == null) {
                throw new CREIllegalStateException("Serial port was not opened.", t);
            }
            try {
                serialPort.closePort();
            }
            catch (SerialPortException serialPortException) {
                // empty catch block
            }
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_is_connected
    extends SerialConnectionFunction {
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {string portName} Returns true if this port was opened by " + serial_connect.class.getSimpleName() + "(), and not yet closed by " + serial_disconnect.class.getSimpleName() + "(). Note that connection failures are not automatically detected, and therefore not considered by this function.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            return CBoolean.GenerateCBoolean((boolean)MSSerialConnection.SERIAL_CONNECTIONS.containsKey(portName), (Target)t);
        }
    }

    @api
    public static class serial_connect
    extends SerialConnectionFunction {
        public Integer[] numArgs() {
            return new Integer[]{7};
        }

        public String docs() {
            return "void {string portName, int baudRate, int numDataBits, int numStopBits, string parity, boolean setRTS, boolean setDTR} Opens a serial connection to the given serial port using the given parameters. parity has to be one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE. Many common microprocessors work with settings: numDataBits = 8, numStopBits = 1, parity = PARITY_NONE, setRTS = true and setDTR = true. Look up the specifications of your serial device if this does not work. Throws IllegalArgumentException when parity is not one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE. Throws IllegalStateException when the given serial port has already been opened by " + MSSerialConnection.class.getSimpleName() + ". Throws SerialPortException when connecting failed.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIllegalArgumentException.class, CREIllegalStateException.class, CRESerialPortException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String portName = ArgumentValidation.getStringObject((Mixed)args[0], (Target)t);
            int baudRate = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
            int numDataBits = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
            int numStopBits = ArgumentValidation.getInt32((Mixed)args[3], (Target)t);
            String parityStr = ArgumentValidation.getStringObject((Mixed)args[4], (Target)t);
            boolean setRTS = ArgumentValidation.getBooleanObject((Mixed)args[5], (Target)t);
            boolean setDTR = ArgumentValidation.getBooleanObject((Mixed)args[6], (Target)t);
            int parity = switch (parityStr.toUpperCase()) {
                case "PARITY_NONE" -> 0;
                case "PARITY_ODD" -> 1;
                case "PARITY_EVEN" -> 2;
                case "PARITY_MARK" -> 3;
                case "PARITY_SPACE" -> 4;
                default -> throw new CREIllegalArgumentException("Parity has to be one of: PARITY_NONE, PARITY_ODD, PARITY_EVEN, PARITY_MARK and PARITY_SPACE.", t);
            };
            if (MSSerialConnection.SERIAL_CONNECTIONS.containsKey(portName)) {
                throw new CREIllegalStateException("Serial port already opened by " + MSSerialConnection.class.getSimpleName() + ".", t);
            }
            SerialPort serialPort = new SerialPort(portName);
            try {
                serialPort.openPort();
            }
            catch (SerialPortException e) {
                throw new CRESerialPortException(serialPort, "Failed to open port: " + e.getExceptionType(), t);
            }
            try {
                if (!serialPort.setParams(baudRate, numDataBits, numStopBits, parity, setRTS, setDTR)) {
                    throw new CRESerialPortException(serialPort, "Failed to set serial port connection parameters.", t);
                }
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            try {
                serialPort.addEventListener(serialPortEvent -> {
                    try {
                        byte[] data = serialPort.readBytes();
                        if (data != null) {
                            EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"serial_data_received", (BindableEvent)new SerialDataReceivedEvent(serialPort, data));
                        }
                    }
                    catch (SerialPortException serialPortException) {
                        // empty catch block
                    }
                });
            }
            catch (SerialPortException e) {
                throw new Error(e);
            }
            MSSerialConnection.SERIAL_CONNECTIONS.put(serialPort.getPortName(), serialPort);
            return CVoid.VOID;
        }
    }

    @api
    public static class serial_get_ports
    extends SerialConnectionFunction {
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        public String docs() {
            return "array {} Returns an array containing all serial ports in the system.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray ret = new CArray(t);
            for (String portName : SerialPortList.getPortNames()) {
                ret.push((Mixed)new CString(portName, t), t);
            }
            return ret;
        }
    }
}

