/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.libs.net.fabricmc.mappingio.tree.MappingTree;
import com.commandhelper.packetjumper.Conversions;
import com.commandhelper.packetjumper.PacketJumper;
import com.commandhelper.packetjumper.PacketKind;
import com.commandhelper.packetjumper.PacketUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.lang.reflect.Field;

@typeof(value="com.commandhelper.Packet")
public final class CPacket
extends Construct {
    public static final CClassType TYPE = CClassType.get(CPacket.class);
    private final PacketContainer packet;
    private final PacketType.Protocol protocol;
    private final PacketType.Sender sender;
    private final String name;
    private final String packetType;

    private CPacket(String value, Construct.ConstructType ctype, String name, Target t, PacketContainer packet, PacketType.Protocol protocol, PacketType.Sender sender) {
        super(value, ctype, t);
        this.packet = packet;
        this.name = name;
        this.protocol = protocol;
        this.sender = sender;
        this.packetType = packet.getType().name();
    }

    public static CPacket create(PacketContainer packet, String name, Target target, PacketType.Protocol protocol, PacketType.Sender sender) {
        return new CPacket("PacketData", Construct.ConstructType.RESOURCE, name, target, packet, protocol, sender);
    }

    public String getPacketName() {
        return this.name;
    }

    public boolean isDynamic() {
        return true;
    }

    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    public String docs() {
        return "Wraps a packet class, which is used for raw packet manipulation.";
    }

    public Version since() {
        return MSVersion.V3_3_5;
    }

    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    public int indexFromString(String field, Target t) {
        CArray packetData = (CArray)((ArrayAccess)((ArrayAccess)PacketUtils.getAllPackets().get(this.protocol.name(), t)).get(this.sender == PacketType.Sender.CLIENT ? "IN" : "OUT", t)).get(this.packetType, t);
        CArray fieldData = (CArray)((ArrayAccess)packetData.get("fields", t)).get(field, t);
        int index = (int)((CInt)fieldData.get("field", t)).getInt();
        return index;
    }

    public Object read(int index) {
        return this.packet.getModifier().read(index);
    }

    public Mixed readMixed(int index, Target target) {
        return Conversions.convertObjectToMixed(this.read(index));
    }

    public Mixed readMixed(String index, Target target) {
        return this.readMixed(this.indexFromString(index, target), target);
    }

    public void write(int index, Object object) {
        this.packet.getModifier().write(index, object);
    }

    public void writeMixed(int index, Mixed mixed, Target t) {
        Field field = this.packet.getModifier().getField(index);
        Class<?> type = field.getType();
        this.write(index, Conversions.adjustObject(Conversions.convertMixedToObject(mixed, type, t), type));
    }

    public void writeMixed(String field, Mixed mixed, Target t) {
        this.writeMixed(this.indexFromString(field, t), mixed, t);
    }

    public CArray getFields(Target target) {
        CArray information = new CArray(target);
        for (FieldAccessor field : this.packet.getModifier().getFields()) {
            information.push((Mixed)new CString(field.getField().getType().getSimpleName(), target), target);
        }
        return information;
    }

    public void send(MCPlayer player, Target target) {
        ProtocolLibrary.getProtocolManager().sendServerPacket(((BukkitMCPlayer)player)._Player(), this.packet);
    }

    public PacketKind getKind() {
        return PacketUtils.getPacketKind(this.packet.getType());
    }

    public CArray toCArray() {
        CArray array = new CArray(Target.UNKNOWN);
        MappingTree tree = PacketJumper.GetMappingTree();
        for (FieldAccessor field : this.packet.getModifier().getFields()) {
            MappingTree.FieldMapping fm;
            Object instance = field.get(this.packet.getHandle());
            String type = field.getField().getType().getSimpleName();
            Class<?> clazz = this.packet.getHandle().getClass();
            MappingTree.ClassMapping classMapping = tree.getClass(clazz.getName().replace(".", "/"), PacketJumper.GetServerNamespace());
            while ((fm = classMapping.getField(field.getField().getName(), null)) == null && (clazz = clazz.getSuperclass()) != Object.class && clazz != Record.class) {
                classMapping = tree.getClass(clazz.getName().replace(".", "/"), PacketJumper.GetServerNamespace());
                if (classMapping != null) continue;
                throw new CREPluginInternalException("Cannot find packet superclass.", Target.UNKNOWN);
            }
            String name = fm.getDstName(PacketJumper.GetMojangNamespace());
            Object value = instance == null ? CNull.NULL : (Conversions.getTypeConversion(field.getField().getType()) == null ? new CString("<UNSUPPORTED:" + instance.toString() + ">", Target.UNKNOWN) : Conversions.convertObjectToMixed(instance));
            CArray descriptor = new CArray(Target.UNKNOWN);
            descriptor.set("name", name);
            descriptor.set("type", type);
            descriptor.set("value", (Mixed)value, Target.UNKNOWN);
            array.set(name, (Mixed)descriptor, Target.UNKNOWN);
        }
        return array;
    }
}

