/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.libs.net.fabricmc.mappingio.MappingVisitor;
import com.commandhelper.libs.net.fabricmc.mappingio.format.tiny.Tiny2FileReader;
import com.commandhelper.libs.net.fabricmc.mappingio.tree.MappingTree;
import com.commandhelper.libs.net.fabricmc.mappingio.tree.MemoryMappingTree;
import com.commandhelper.packetjumper.PacketEventNotifier;
import com.comphenix.protocol.ProtocolLibrary;
import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.extensions.AbstractExtension;
import com.laytonsmith.core.extensions.MSExtension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;

@MSExtension(value="PacketJumper")
public class PacketJumper
extends AbstractExtension {
    private Thread protocolThread;
    private static int serverType = -1;
    private static final Map<Version, String> VERSION_MAP = new HashMap<Version, String>(){
        {
            this.put(MCVersion.MC1_20_4, "https://repo.screamingsandals.org/releases/me/kcra/takenaka/mappings/1.8.8+1.20.4/mappings-1.8.8+1.20.4.jar");
        }
    };
    private static final MemoryMappingTree MINECRAFT_MAPPINGS = new MemoryMappingTree();
    private static int spigotNamespace;
    private static int mojangNamespace;
    private static Optional<PacketEventNotifier> packetEventNotifier;

    public Version getVersion() {
        return new SimpleVersion(1, 0, 0);
    }

    public void onLoad() {
        this.protocolThread = new Thread("PacketJumperLoader"){

            @Override
            public void run() {
                try {
                    PacketJumper.Startup();
                }
                catch (IOException ex) {
                    Logger.getLogger(CommandHelperPlugin.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.protocolThread.start();
    }

    public void onStartup() {
        if (this.protocolThread.isAlive()) {
            Logger.getLogger(PacketJumper.class.getName()).log(Level.INFO, "Waiting for protocol mapping to complete...");
            try {
                this.protocolThread.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PacketJumper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void onShutdown() {
        PacketJumper.Shutdown();
    }

    private static String GetUrl() {
        MCVersion currentVersion = Static.getServer().getMinecraftVersion();
        Version bestCandidate = null;
        for (Version v : VERSION_MAP.keySet()) {
            if (v.lt(bestCandidate) || !v.gte((Version)currentVersion)) continue;
            bestCandidate = v;
        }
        return VERSION_MAP.get(bestCandidate);
    }

    public static void Startup() throws MalformedURLException, IOException {
        long time = System.currentTimeMillis();
        boolean downloading = false;
        File protocolLibCache = new File(CommandHelperFileLocations.getDefault().getCacheDirectory(), "ProtocolLib");
        URL url = new URL(PacketJumper.GetUrl());
        String[] parts = url.getPath().split("/");
        String filename = parts[parts.length - 1];
        protocolLibCache.mkdirs();
        File mappingsJar = new File(protocolLibCache, filename);
        if (!mappingsJar.exists()) {
            downloading = true;
            RequestSettings requestSettings = new RequestSettings().setDownloadTo(mappingsJar).setDownloadStrategy(FileWriteMode.SAFE_WRITE).setBlocking(true);
            WebUtility.GetPage((URL)url, (RequestSettings)requestSettings);
        }
        MCVersion currentVersion = Static.getServer().getMinecraftVersion();
        String mcVersion = currentVersion.getMajor() + "." + currentVersion.getMinor() + "." + currentVersion.getSupplemental();
        ZipReader tinyFileReader = new ZipReader(new File(mappingsJar, mcVersion + ".tiny"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(tinyFileReader.getInputStream(), StandardCharsets.UTF_8));
        Tiny2FileReader.read(reader, (MappingVisitor)MINECRAFT_MAPPINGS);
        spigotNamespace = MINECRAFT_MAPPINGS.getNamespaceId("spigot");
        mojangNamespace = MINECRAFT_MAPPINGS.getNamespaceId("mojang");
        long ms = System.currentTimeMillis() - time;
        Static.getLogger().log(Level.INFO, "Loading {0}mappings took {1}ms", new Object[]{downloading ? "and downloading " : "", ms});
        packetEventNotifier = Optional.of(new PacketEventNotifier((Plugin)CommandHelperPlugin.self, ProtocolLibrary.getProtocolManager()));
    }

    public static void Shutdown() {
        packetEventNotifier.ifPresent(e -> e.unregister());
    }

    public static Optional<PacketEventNotifier> GetPacketEventNotifier() {
        return packetEventNotifier;
    }

    public static MappingTree GetMappingTree() {
        return MINECRAFT_MAPPINGS;
    }

    public static int GetServerNamespace() {
        if (serverType == -1) {
            serverType = PacketJumper.GetMojangNamespace();
            if (ReflectionUtils.classExists((String)"net.minecraft.network.protocol.status.PacketStatusInStart")) {
                serverType = PacketJumper.GetSpigotNamespace();
            }
        }
        return serverType;
    }

    public static int GetSpigotNamespace() {
        return spigotNamespace;
    }

    public static int GetMojangNamespace() {
        return mojangNamespace;
    }

    static {
        packetEventNotifier = Optional.empty();
    }
}

