/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.libs.net.fabricmc.mappingio.tree.MappingTree;
import com.commandhelper.packetjumper.PacketJumper;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;

public final class Conversions {
    private Conversions() {
    }

    public static Object convertMixedToObject(Mixed mixed, Class<?> type, Target t) {
        if (Enum.class.isAssignableFrom(type)) {
            return Conversions.getEnum(mixed.val(), type);
        }
        if (MinecraftReflection.getIChatBaseComponentClass().isAssignableFrom(type)) {
            String contents = mixed.val();
            return contents.startsWith("{") && contents.endsWith("}") ? WrappedChatComponent.fromJson((String)contents).getHandle() : WrappedChatComponent.fromText((String)contents).getHandle();
        }
        if (MinecraftReflection.getItemStackClass().isAssignableFrom(type)) {
            return ObjectGenerator.GetGenerator().item(mixed, t);
        }
        if (MinecraftReflection.getBlockPositionClass().isAssignableFrom(type)) {
            CArray array2 = ArgumentValidation.getArray((Mixed)mixed, (Target)t);
            int x = ArgumentValidation.getInt32((Mixed)array2.get("x", t), (Target)t);
            int y = ArgumentValidation.getInt32((Mixed)array2.get("y", t), (Target)t);
            int z = ArgumentValidation.getInt32((Mixed)array2.get("z", t), (Target)t);
            return ReflectionUtils.newInstance((Class)MinecraftReflection.getBlockPositionClass(), (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{x, y, z});
        }
        return Static.getJavaObject((Mixed)mixed);
    }

    public static CClassType getTypeConversion(Class clazz) {
        CArray enumTypes = new CArray(Target.UNKNOWN);
        String desc = ClassUtils.getJVMName((Class)clazz);
        if (clazz.isEnum()) {
            for (Object o : clazz.getEnumConstants()) {
                enumTypes.push((Mixed)new CString(o.toString(), Target.UNKNOWN), Target.UNKNOWN);
            }
            return CString.TYPE;
        }
        switch (desc) {
            case "I": {
                return CInt.TYPE;
            }
            case "Z": {
                return CBoolean.TYPE;
            }
            case "B": 
            case "J": 
            case "S": {
                return CInt.TYPE;
            }
            case "D": 
            case "F": {
                return CDouble.TYPE;
            }
            case "Ljava/lang/String;": 
            case "Ljava/util/UUID;": {
                return CString.TYPE;
            }
            case "Ljava/util/List;": 
            case "Ljava/util/Collection;": 
            case "Ljava/util/Set;": 
            case "Ljava/util/EnumSet;": 
            case "Ljava/util/Map;": 
            case "[Ljava/lang/String;": 
            case "[I": 
            case "[S": {
                return CArray.TYPE;
            }
            case "[B": {
                return CByteArray.TYPE;
            }
        }
        if (MinecraftReflection.getIChatBaseComponentClass().isAssignableFrom(clazz)) {
            return CString.TYPE;
        }
        if (MinecraftReflection.getItemStackClass().isAssignableFrom(clazz)) {
            return CArray.TYPE;
        }
        if (MinecraftReflection.getBlockPositionClass().isAssignableFrom(clazz)) {
            return CArray.TYPE;
        }
        return null;
    }

    public static Object adjustObject(Object object, Class<?> type) {
        if (type == Integer.TYPE && object instanceof Number) {
            Number n = (Number)object;
            return n.intValue();
        }
        if (type == Short.TYPE && object instanceof Number) {
            Number n = (Number)object;
            return n.shortValue();
        }
        if (type == Byte.TYPE && object instanceof Number) {
            Number n = (Number)object;
            return n.byteValue();
        }
        return object;
    }

    public static Mixed convertObjectToMixed(Object object) {
        if (object == null) {
            return CNull.NULL;
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Enum) {
            Enum aEnum = (Enum)object;
            return new CString(aEnum.name(), Target.UNKNOWN);
        }
        if (MinecraftReflection.getIChatBaseComponentClass().isAssignableFrom(clazz)) {
            return new CString(object.toString(), Target.UNKNOWN);
        }
        if (MinecraftReflection.getItemStackClass().isAssignableFrom(clazz)) {
            Object itemStack = ReflectionUtils.invokeMethod((Object)object, (String)"getBukkitStack");
            return ObjectGenerator.GetGenerator().item((MCItemStack)new BukkitMCItemStack((ItemStack)itemStack), Target.UNKNOWN);
        }
        if (MinecraftReflection.getBlockPositionClass().isAssignableFrom(clazz)) {
            List<String> list = Stream.of(object.getClass().getDeclaredMethods()).map(x -> x.getName()).toList();
            System.out.println(list);
            MappingTree tree = PacketJumper.GetMappingTree();
            MappingTree.ClassMapping vec3i = tree.getClass(object.getClass().getSuperclass().getName().replace(".", "/"), PacketJumper.GetServerNamespace());
            int x2 = (Integer)ReflectionUtils.invokeMethod((Object)object, (String)vec3i.getMethod("getX", null, PacketJumper.GetMojangNamespace()).getSrcName());
            int y = (Integer)ReflectionUtils.invokeMethod((Object)object, (String)vec3i.getMethod("getY", null, PacketJumper.GetMojangNamespace()).getSrcName());
            int z = (Integer)ReflectionUtils.invokeMethod((Object)object, (String)vec3i.getMethod("getZ", null, PacketJumper.GetMojangNamespace()).getSrcName());
            CArray array2 = new CArray(Target.UNKNOWN);
            array2.set("x", x2);
            array2.set("y", y);
            array2.set("z", z);
            return array2;
        }
        return Static.getMSObject((Object)object, (Target)Target.UNKNOWN);
    }

    public static Object getEnum(String name, Class enumType) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException ex) {
            Object[] enums = (Enum[])ReflectionUtils.invokeMethod((Class)enumType, null, (String)"values");
            throw new IllegalArgumentException(String.format("%s has elements [%s]", enumType.getSimpleName(), StringUtils.Join((Object[])enums, (String)", ")));
        }
    }
}

