/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.packetjumper.ProtocolLibPacketEvent;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public class PacketEventNotifier {
    private final Plugin plugin;
    private final ProtocolManager protocolManager;
    private final Collection<PacketAdapter> packetAdapters = new ArrayList<PacketAdapter>();
    private final Set<PacketType> registeredTypes = new HashSet<PacketType>();

    public PacketEventNotifier(Plugin plugin, ProtocolManager protocolManager) {
        this.plugin = plugin;
        this.protocolManager = protocolManager;
    }

    public void onPacketReceiving(PacketEvent event) {
        ProtocolLibPacketEvent packetEvent = new ProtocolLibPacketEvent(event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"packet_received", (BindableEvent)packetEvent);
    }

    public void onPacketSending(PacketEvent event) {
        ProtocolLibPacketEvent packetEvent = new ProtocolLibPacketEvent(event);
        EventUtils.TriggerListener((Driver)Driver.EXTENSION, (String)"packet_sent", (BindableEvent)packetEvent);
    }

    public void register(ListenerPriority priority, PacketType type) {
        if (this.registeredTypes.contains(type)) {
            return;
        }
        PacketAdapter adapter = new PacketAdapter(this.plugin, priority, new PacketType[]{type}){

            public void onPacketReceiving(PacketEvent event) {
                PacketEventNotifier.this.onPacketReceiving(event);
            }

            public void onPacketSending(PacketEvent event) {
                PacketEventNotifier.this.onPacketSending(event);
            }
        };
        this.packetAdapters.add(adapter);
        this.protocolManager.addPacketListener((PacketListener)adapter);
        this.registeredTypes.add(type);
    }

    public void unregister() {
        for (PacketAdapter adapter : this.packetAdapters) {
            this.protocolManager.removePacketListener((PacketListener)adapter);
        }
        this.packetAdapters.clear();
        this.registeredTypes.clear();
    }
}

