/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.libs.net.fabricmc.mappingio.tree.MappingTree;
import com.commandhelper.packetjumper.CPacket;
import com.commandhelper.packetjumper.Conversions;
import com.commandhelper.packetjumper.PacketDirection;
import com.commandhelper.packetjumper.PacketJumper;
import com.commandhelper.packetjumper.PacketKind;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PacketUtils {
    private static volatile CArray allPackets = null;
    private static final Object ALL_PACKETS_LOCK = new Object();

    private PacketUtils() {
    }

    public static CArray getAllPackets() {
        return PacketUtils.getAllPacketsInternal().clone();
    }

    public static List<PacketType> SupportedPackets() {
        ArrayList<PacketType> output = new ArrayList<PacketType>();
        for (Set set : new Set[]{PacketRegistry.getServerPacketTypes(), PacketRegistry.getClientPacketTypes()}) {
            for (PacketType type : set) {
                if (type.name() == null || type.isDynamic()) continue;
                output.add(type);
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CArray getAllPacketsInternal() {
        CArray allPackets = PacketUtils.allPackets;
        if (allPackets == null) {
            Object object = ALL_PACKETS_LOCK;
            synchronized (object) {
                allPackets = PacketUtils.allPackets;
                if (allPackets == null) {
                    CArray packetTypeArray = new CArray(Target.UNKNOWN);
                    for (PacketType.Protocol protocol : PacketType.Protocol.values()) {
                        CArray subtypes = new CArray(Target.UNKNOWN);
                        subtypes.set("IN", (Mixed)new CArray(Target.UNKNOWN), Target.UNKNOWN);
                        subtypes.set("OUT", (Mixed)new CArray(Target.UNKNOWN), Target.UNKNOWN);
                        packetTypeArray.set(protocol.name(), (Mixed)subtypes, Target.UNKNOWN);
                    }
                    List<PacketType> output = PacketUtils.SupportedPackets();
                    HashSet<String> unsupportedTypes = new HashSet<String>();
                    for (PacketType type : output) {
                        try {
                            CArray array2 = (CArray)((ArrayAccess)packetTypeArray.get(type.getProtocol().name(), Target.UNKNOWN)).get(type.getSender() == PacketType.Sender.CLIENT ? "IN" : "OUT", Target.UNKNOWN);
                            array2.set(type.name().toUpperCase(), (Mixed)PacketUtils.getPacketInfo(type, unsupportedTypes), Target.UNKNOWN);
                        }
                        catch (ClassNotFoundException ex) {
                            Logger.getLogger(PacketJumper.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    CArray array3 = new CArray(Target.UNKNOWN);
                    for (String s : unsupportedTypes) {
                        array3.push(s);
                    }
                    packetTypeArray.set("__UnsupportedTypes", (Mixed)array3, Target.UNKNOWN);
                    PacketUtils.allPackets = packetTypeArray;
                }
            }
        }
        return PacketUtils.allPackets;
    }

    private static CArray getPacketInfo(PacketType type, Set<String> unsupportedTypes) throws ClassNotFoundException {
        int serverType = PacketJumper.GetServerNamespace();
        CArray arr = new CArray(Target.UNKNOWN);
        arr.set("protocol", type.getProtocol().name());
        arr.set("name", type.name().toUpperCase());
        arr.set("sender", type.getSender().name());
        arr.set("deprecated", (Mixed)CBoolean.get((boolean)type.isDeprecated()), Target.UNKNOWN);
        MappingTree tree = PacketJumper.GetMappingTree();
        MappingTree.ClassMapping mapping = tree.getClass(type.getPacketClass().getName().replace(".", "/"), serverType);
        Class clazz = ClassUtils.forCanonicalName((String)mapping.getName(serverType).replace("/", "."));
        arr.set("class", mapping.getName(PacketJumper.GetMojangNamespace()).replace("/", "."));
        arr.set("superclass", clazz.getSuperclass().getName());
        arr.set("comment", mapping.getComment());
        CArray fields = new CArray(Target.UNKNOWN);
        int index = 0;
        do {
            for (MappingTree.FieldMapping fieldMapping : mapping.getFields()) {
                if ((PacketUtils.getJavaField(fieldMapping, clazz).getModifiers() & 8) > 0) continue;
                CArray field = new CArray(Target.UNKNOWN);
                field.set("name", fieldMapping.getName(PacketJumper.GetMojangNamespace()));
                CNull typeData = CNull.NULL;
                try {
                    typeData = PacketUtils.getTypeData(fieldMapping.getSrcName(), fieldMapping.getDesc(PacketJumper.GetMojangNamespace()), clazz, ClassUtils.forCanonicalName((String)ClassUtils.getCommonNameFromJVMName((String)fieldMapping.getDesc(serverType))), unsupportedTypes);
                }
                catch (ClassNotFoundException | NoSuchFieldException ex) {
                    Logger.getLogger(PacketJumper.class.getName()).log(Level.SEVERE, null, ex);
                }
                field.set("type", (Mixed)typeData, Target.UNKNOWN);
                int currentId = index++;
                field.set("field", currentId);
                field.set("comment", fieldMapping.getComment());
                fields.set(fieldMapping.getName(PacketJumper.GetMojangNamespace()), (Mixed)field, Target.UNKNOWN);
            }
            clazz = clazz.getSuperclass();
            mapping = tree.getClass(clazz.getName().replace(".", "/"), serverType);
        } while (clazz != Object.class && clazz != Record.class);
        arr.set("fields", (Mixed)fields, Target.UNKNOWN);
        arr.set("id", (Mixed)new CInt((long)type.getCurrentId(), Target.UNKNOWN), Target.UNKNOWN);
        return arr;
    }

    private static CArray getTypeData(String nativeFieldName, String type, Class containingClazz, Class clazz, Set<String> unsupportedTypes) throws NoSuchFieldException, ClassNotFoundException {
        CArray array2 = new CArray(Target.UNKNOWN);
        CArray enumTypes = new CArray(Target.UNKNOWN);
        CClassType ctype = Conversions.getTypeConversion(clazz);
        if (clazz.isEnum()) {
            for (Object o : clazz.getEnumConstants()) {
                enumTypes.push((Mixed)new CString(o.toString(), Target.UNKNOWN), Target.UNKNOWN);
            }
            ctype = CString.TYPE;
            array2.set("enumType", ClassUtils.getCommonNameFromJVMName((String)type));
            array2.set("enumValues", (Mixed)enumTypes, Target.UNKNOWN);
        }
        if (ctype == null) {
            unsupportedTypes.add(type);
        }
        array2.set("type", ctype == null ? "<UNSUPPORTED>" : ctype.getFQCN().getFQCN());
        if (CArray.TYPE.equals((Object)ctype)) {
            if (type.startsWith("[")) {
                Class subtype = ClassUtils.forCanonicalName((String)ClassUtils.getCommonNameFromJVMName((String)type.substring(1)));
                CClassType genericType = Conversions.getTypeConversion(subtype);
                array2.set("genericType", (Mixed)(genericType == null ? new CString("<UNSUPPORTED>", Target.UNKNOWN) : genericType), Target.UNKNOWN);
            } else {
                ParameterizedType generic;
                Type[] types;
                CArray genericType;
                Field f = containingClazz.getDeclaredField(nativeFieldName);
                Type type2 = f.getGenericType();
                if (type2 instanceof ParameterizedType && (genericType = PacketUtils.parseSubtype(types = (generic = (ParameterizedType)type2).getActualTypeArguments(), clazz)) != null) {
                    array2.set("genericType", (Mixed)genericType, Target.UNKNOWN);
                }
            }
        }
        array2.set("originalType", ClassUtils.getCommonNameFromJVMName((String)type));
        return array2;
    }

    private static CArray parseSubtype(Type[] types, Class clazz) {
        CArray array2 = new CArray(Target.UNKNOWN);
        Type t = types[0];
        if (clazz == Map.class) {
            if (!t.getTypeName().equals("java.lang.String")) {
                array2.set("type", "<UNSUPPORTED>");
            } else {
                t = types[1];
            }
        } else if (t instanceof Class) {
            Class type = (Class)t;
            CClassType c = Conversions.getTypeConversion(type);
            array2.set("type", (Mixed)(c == null ? new CString("<UNSUPPORTED>", Target.UNKNOWN) : c), Target.UNKNOWN);
            array2.set("originalType", type.getName());
        } else if (t instanceof ParameterizedType) {
            CArray genericType;
            ParameterizedType type = (ParameterizedType)t;
            CClassType c = Conversions.getTypeConversion((Class)type.getRawType());
            array2.set("type", (Mixed)(c == null ? new CString("<UNSUPPORTED>", Target.UNKNOWN) : c), Target.UNKNOWN);
            array2.set("originalType", ((Class)type.getRawType()).getName());
            if (c != null && type.getActualTypeArguments().length > 0 && (genericType = PacketUtils.parseSubtype(type.getActualTypeArguments(), (Class)type.getRawType())) != null) {
                array2.set("genericType", (Mixed)genericType, Target.UNKNOWN);
            }
        }
        if (t instanceof WildcardType) {
            return null;
        }
        return array2;
    }

    public static Field getJavaField(MappingTree.FieldMapping fm, Class clazz) {
        String field = fm.getSrcName();
        while (true) {
            try {
                return clazz.getDeclaredField(field);
            }
            catch (NoSuchFieldException ex) {
                if ((clazz = clazz.getSuperclass()) != Object.class && clazz != Record.class) continue;
                return null;
            }
            break;
        }
    }

    public static PacketType.Sender getSide(String name, Target target) {
        switch (name) {
            case "IN": {
                return PacketType.Sender.CLIENT;
            }
            case "OUT": {
                return PacketType.Sender.SERVER;
            }
        }
        throw new CREIllegalArgumentException("Unknown sender type: " + name, target);
    }

    public static PacketType findPacketTypeByCommonName(String protocol, String name, Target target) {
        for (PacketType type : PacketUtils.SupportedPackets()) {
            if (!type.getProtocol().name().equals(protocol) || !type.name().equals(name)) continue;
            return type;
        }
        throw new CREIllegalArgumentException("Error while finding the packet of type \"" + protocol + "\":\"" + name + "\". Check the results of all_packets() for information about valid packet types.", target);
    }

    public static PacketType findPacketTypeByClassName(String protocol, String className, Target target) {
        try {
            MappingTree tree = PacketJumper.GetMappingTree();
            className = tree.getClass(className.replace(".", "/"), PacketJumper.GetMojangNamespace()).getDstName(PacketJumper.GetServerNamespace()).replace("/", ".");
            return PacketRegistry.getPacketType((PacketType.Protocol)PacketType.Protocol.valueOf((String)protocol), Class.forName(className));
        }
        catch (Exception exception) {
            throw new CREIllegalArgumentException("Error while finding the packet of type \"" + protocol + "\":\"" + className + "\". Check the results of all_packets() for information about valid packet types.", target, (Throwable)exception);
        }
    }

    public static CPacket createPacket(String protocol, PacketDirection side, String name, Target target) {
        try {
            String clazz;
            CArray packetData = (CArray)((ArrayAccess)((ArrayAccess)PacketUtils.getAllPacketsInternal().get(protocol, target)).get(side.name(), target)).get(name, target);
            name = clazz = packetData.get("class", target).val();
        }
        catch (CREIndexOverflowException packetData) {
            // empty catch block
        }
        PacketContainer container = ProtocolLibrary.getProtocolManager().createPacket(PacketUtils.findPacketTypeByClassName(protocol, name, target));
        return CPacket.create(container, name, target, PacketType.Protocol.valueOf((String)protocol), side == PacketDirection.IN ? PacketType.Sender.CLIENT : PacketType.Sender.SERVER);
    }

    public static PacketKind getPacketKind(PacketType type) {
        return new PacketKind(type.getProtocol().name(), type.getSender().getPacketName().toUpperCase(), type.name().toUpperCase());
    }
}

