/*
 * Decompiled with CFR 0.152.
 */
package com.commandhelper.packetjumper;

import com.commandhelper.libs.net.fabricmc.mappingio.tree.MappingTree;
import com.commandhelper.packetjumper.Comparisons;
import com.commandhelper.packetjumper.Conversions;
import com.commandhelper.packetjumper.PacketDirection;
import com.commandhelper.packetjumper.PacketJumper;
import com.commandhelper.packetjumper.PacketUtils;
import com.commandhelper.packetjumper.ProtocolLibPacketEvent;
import com.comphenix.protocol.PacketType;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.events.AbstractGenericEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.prefilters.CustomPrefilterMatcher;
import com.laytonsmith.core.events.prefilters.EnumPrefilterMatcher;
import com.laytonsmith.core.events.prefilters.PlayerPrefilterMatcher;
import com.laytonsmith.core.events.prefilters.Prefilter;
import com.laytonsmith.core.events.prefilters.PrefilterBuilder;
import com.laytonsmith.core.events.prefilters.PrefilterMatcher;
import com.laytonsmith.core.events.prefilters.StringPrefilterMatcher;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public final class PacketEvents {
    private PacketEvents() {
    }

    public static String docs() {
        return "Contains events related to packet management. PacketJumper must be enabled for these events to fire.";
    }

    private static PrefilterBuilder GetPacketPrefilter() {
        return new PrefilterBuilder().set("protocol", "The protocol of the packet.", (PrefilterMatcher)new StringPrefilterMatcher<ProtocolLibPacketEvent>(){

            protected String getProperty(ProtocolLibPacketEvent event) {
                return event.getPacketEvent().getPacketType().getProtocol().name();
            }
        }).set("type", "The packet type.", (PrefilterMatcher)new StringPrefilterMatcher<ProtocolLibPacketEvent>(){

            protected String getProperty(ProtocolLibPacketEvent event) {
                return event.getPacketEvent().getPacketType().name();
            }
        }).set("direction", "The packet direction.", (PrefilterMatcher)new EnumPrefilterMatcher<ProtocolLibPacketEvent, PacketDirection>(PacketDirection.class){

            protected Enum<PacketDirection> getEnum(ProtocolLibPacketEvent event) {
                return event.getPacketEvent().getPacketType().getSender() == PacketType.Sender.CLIENT ? PacketDirection.IN : PacketDirection.OUT;
            }
        }).set("player", "The player that the packet is being sent to/from", (PrefilterMatcher)new PlayerPrefilterMatcher()).set("values", "An associative array of value matches. The key should be the field name to match, and the value should be the desired match. This only supports exact matches.", (PrefilterMatcher)new CustomPrefilterMatcher<ProtocolLibPacketEvent>(){

            public boolean matches(String key, Mixed value, ProtocolLibPacketEvent event, Target t) {
                if (!(value instanceof CArray)) {
                    throw new CREIllegalArgumentException("\"values\" prefilter must be an array.", t);
                }
                Object packet = event.getInternalPacket().getHandle();
                MappingTree tree = PacketJumper.GetMappingTree();
                MappingTree.ClassMapping classMapping = tree.getClass(event.getPacketEvent().getPacketType().getPacketClass().getName().replace(".", "/"), PacketJumper.GetServerNamespace());
                if (classMapping == null) {
                    throw new CREPluginInternalException("Cannot find packet class.", t);
                }
                for (Mixed k : ((ArrayAccess)value).keySet()) {
                    Class clazz = event.getPacketEvent().getPacketType().getPacketClass();
                    MappingTree.FieldMapping fm = null;
                    while ((fm = classMapping.getField(k.val(), null, PacketJumper.GetMojangNamespace())) == null && (clazz = clazz.getSuperclass()) != Object.class && clazz != Record.class) {
                        classMapping = tree.getClass(clazz.getName().replace(".", "/"), PacketJumper.GetServerNamespace());
                        if (classMapping != null) continue;
                        throw new CREPluginInternalException("Cannot find packet superclass.", t);
                    }
                    if (fm == null) {
                        throw new CREIllegalArgumentException("Invalid property \"" + k.val() + "\"", t);
                    }
                    String tK = fm.getSrcName();
                    Mixed v = ((ArrayAccess)value).get(k, t);
                    Object oV = Conversions.convertMixedToObject(v, clazz, t);
                    Object packetPropertyValue = ReflectionUtils.get(clazz, (Object)packet, (String)tK);
                    if (!(packetPropertyValue == null ? oV != null : !Comparisons.IsEqual(oV, packetPropertyValue))) continue;
                    return false;
                }
                return true;
            }

            public int getPriority() {
                return 100;
            }
        });
    }

    private static void DoCrossPrefilterValidation(Map<Prefilter<ProtocolLibPacketEvent>, ParseTree> prefilters, Environment env) throws ConfigCompileException, ConfigCompileGroupException {
        CFunction f;
        ParseTree node;
        ParseTree parseTree;
        ArrayList<String> prefilterTypes = new ArrayList<String>();
        Prefilter<ProtocolLibPacketEvent> valuesPrefilter = null;
        String protocol = null;
        String type = null;
        for (Prefilter<ProtocolLibPacketEvent> p : prefilters.keySet()) {
            prefilterTypes.add(p.getPrefilterName());
            parseTree = prefilters.get(p);
            switch (p.getPrefilterName()) {
                case "values": {
                    valuesPrefilter = p;
                    break;
                }
                case "protocol": {
                    if (!parseTree.isConst()) break;
                    protocol = parseTree.getData().val();
                    break;
                }
                case "type": {
                    if (!parseTree.isConst()) break;
                    type = parseTree.getData().val();
                    break;
                }
            }
        }
        if (!(!prefilterTypes.contains("values") || prefilterTypes.contains("protocol") && prefilterTypes.contains("type"))) {
            ParseTree valuesParseTree = prefilters.get(valuesPrefilter);
            ((CompilerEnvironment)env.getEnv(CompilerEnvironment.class)).addCompilerWarning(valuesParseTree.getFileOptions(), new CompilerWarning("\"values\" prefilter cannot be made to work reliably without specifying protocol and type values, as this will match multiple packet types, each with different values, so this cannot be made to work generically, unless you happen to only be registering for a single packet type. Add a 'protocol' and 'type' prefilter also to get rid of this warning.", valuesParseTree.getTarget(), null));
            return;
        }
        if (prefilterTypes.contains("values") && protocol != null && type != null && (parseTree = (node = prefilters.get(valuesPrefilter)).getData()) instanceof CFunction && ((f = (CFunction)parseTree).getFunction() instanceof DataHandling.array || f.getFunction() instanceof DataHandling.associative_array)) {
            HashSet<String> labels = new HashSet<String>();
            for (int i = 0; i < node.numberOfChildren(); ++i) {
                CFunction centryFunction;
                ParseTree child = node.getChildAt(i);
                Mixed mixed = child.getData();
                if (!(mixed instanceof CFunction) || !((centryFunction = (CFunction)mixed).getFunction() instanceof Compiler.centry)) continue;
                labels.add(((CLabel)child.getChildAt(0).getData()).cVal().val());
            }
            PacketType packetType = PacketUtils.findPacketTypeByCommonName(protocol, type, node.getTarget());
            HashSet<ConfigCompileException> errors = new HashSet<ConfigCompileException>();
            block12: for (String property : labels) {
                Class clazz = packetType.getPacketClass();
                MappingTree.FieldMapping fm = null;
                MappingTree tree = PacketJumper.GetMappingTree();
                MappingTree.ClassMapping classMapping = tree.getClass(clazz.getName().replace(".", "/"), PacketJumper.GetServerNamespace());
                if (classMapping == null) {
                    throw new ConfigCompileException("Cannot find packet class.", node.getTarget());
                }
                while ((fm = classMapping.getField(property, null, PacketJumper.GetMojangNamespace())) == null && (clazz = clazz.getSuperclass()) != Object.class && clazz != Record.class) {
                    classMapping = tree.getClass(clazz.getName().replace(".", "/"), PacketJumper.GetServerNamespace());
                    if (classMapping != null) continue;
                    errors.add(new ConfigCompileException("Cannot find packet superclass.", node.getTarget()));
                    continue block12;
                }
                if (fm != null) continue;
                errors.add(new ConfigCompileException("Invalid property \"" + property + "\"", node.getTarget()));
            }
            if (!errors.isEmpty()) {
                throw new ConfigCompileGroupException(errors);
            }
        }
    }

    @api
    public static class packet_sent
    extends PacketEvent {
        public String getName() {
            return "packet_sent";
        }

        public String docs() {
            return "{} Fires when a packet is sent from the server. Cancelling the event will cause the packet to not be sent to the client. {player: the player the packet was received from | type: the packet type | fields: an array of fields that map to values which should be handled. Missing fields match any value.} {} {}";
        }
    }

    @api
    public static class packet_received
    extends PacketEvent {
        public String getName() {
            return "packet_received";
        }

        public String docs() {
            return "{} Fires when a packet is received from a client. Cancelling the event will cause the packet to not be processed by the server. {player: the player the packet was received from | type: the packet type | fields: an array of fields that map to values which should be handled. Missing fields match any value.} {} {}";
        }
    }

    public static abstract class PacketEvent
    extends AbstractGenericEvent<ProtocolLibPacketEvent> {
        public ProtocolLibPacketEvent convert(CArray manualObject, Target t) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, Mixed> evaluate(ProtocolLibPacketEvent e) throws EventException {
            Map map = this.evaluate_helper(e);
            map.put("macrotype", new CString("packet", Target.UNKNOWN));
            map.put("player", new CString(e.getPlayer().getName(), Target.UNKNOWN));
            map.put("packet", e.getPacket(Target.UNKNOWN));
            map.put("protocol", new CString(e.getPacketEvent().getPacketType().getProtocol().name(), Target.UNKNOWN));
            map.put("type", new CString(e.getPacketEvent().getPacketType().name(), Target.UNKNOWN));
            map.put("direction", new CString(PacketDirection.FromSender(e.getPacketEvent().getPacketType().getSender()).name(), Target.UNKNOWN));
            return map;
        }

        public boolean modifyEvent(String key, Mixed value, ProtocolLibPacketEvent event) {
            throw new CREUnsupportedOperationException("Cannot modify the packet event, use packet_write to modify individual parameters.", value.getTarget());
        }

        public Version since() {
            return MSVersion.V3_3_5;
        }

        protected PrefilterBuilder getPrefilterBuilder() {
            return PacketEvents.GetPacketPrefilter();
        }

        public void validatePrefilters(Map<Prefilter<ProtocolLibPacketEvent>, ParseTree> prefilters, Environment env) throws ConfigCompileException, ConfigCompileGroupException {
            PacketEvents.DoCrossPrefilterValidation(prefilters, env);
        }

        public void cancel(ProtocolLibPacketEvent o, boolean state) {
            o.getPacketEvent().setCancelled(state);
        }

        public Driver driver() {
            return Driver.EXTENSION;
        }
    }
}

