/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.io.Closer;
import io.github.jbaero.skcompat.SKWorldEdit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.bukkit.Location;

public class SKClipboard {
    public static void Copy(MCCommandSender sender, MCLocation loc, boolean entities, boolean biomes, Target t) {
        Actor user = SKWorldEdit.GetActor(sender, t);
        LocalSession session = SKWorldEdit.GetLocalSession(user);
        EditSession editSession = SKWorldEdit.GetEditSession(user, false);
        try {
            Region region = session.getSelection();
            BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
            BlockVector3 pos = session.getPlacementPosition(user);
            if (loc != null) {
                pos = BukkitAdapter.asBlockVector((Location)((Location)loc.getHandle()));
            }
            clipboard.setOrigin(pos);
            ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, region, (Extent)clipboard, region.getMinimumPoint());
            copy.setCopyingEntities(entities);
            copy.setCopyingBiomes(biomes);
            Operations.complete((Operation)copy);
            session.setClipboard(new ClipboardHolder((Clipboard)clipboard));
        }
        catch (IncompleteRegionException ex) {
            throw new CREPluginInternalException("Incomplete selection, expecting both pos1 and pos2 to be set.", t);
        }
        catch (Exception wee) {
            throw new CREPluginInternalException(wee.getMessage(), t, (Throwable)wee);
        }
    }

    public static void Load(MCCommandSender sender, String filename, Target t) {
        File f;
        WorldEdit worldEdit = WorldEdit.getInstance();
        Actor user = SKWorldEdit.GetActor(sender, t);
        LocalSession session = SKWorldEdit.GetLocalSession(user);
        Path dir = worldEdit.getWorkingDirectoryPath(worldEdit.getConfiguration().saveDir);
        try {
            f = worldEdit.getSafeOpenFile(user, dir.toFile(), filename, "schem", new String[]{"schematic"});
        }
        catch (Exception fne) {
            throw new CREFormatException(fne.getMessage(), t);
        }
        try (Closer closer = Closer.create();){
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(f));
            BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
            ClipboardReader reader = f.getName().endsWith(".schem") ? (ClipboardReader)closer.register((Closeable)BuiltInClipboardFormat.SPONGE_SCHEMATIC.getReader((InputStream)bis)) : (ClipboardReader)closer.register((Closeable)BuiltInClipboardFormat.MCEDIT_SCHEMATIC.getReader((InputStream)bis));
            Clipboard clipboard = reader.read();
            session.setClipboard(new ClipboardHolder(clipboard));
        }
        catch (IOException e) {
            throw new CREIOException("Schematic could not read or it does not exist: " + e.getMessage(), t);
        }
    }

    public static void Save(MCCommandSender sender, String filename, Target t) {
        File f;
        Clipboard clipboard;
        WorldEdit worldEdit = WorldEdit.getInstance();
        Actor user = SKWorldEdit.GetActor(sender, t);
        LocalSession session = SKWorldEdit.GetLocalSession(user);
        try {
            clipboard = session.getClipboard().getClipboard();
        }
        catch (Exception e) {
            throw new CRENotFoundException("The clipboard is empty, copy something to it first!", t);
        }
        Path dir = worldEdit.getWorkingDirectoryPath(worldEdit.getConfiguration().saveDir);
        try {
            f = worldEdit.getSafeSaveFile(user, dir.toFile(), filename, "schem", new String[0]);
        }
        catch (Exception fne) {
            throw new CREFormatException(fne.getMessage(), t);
        }
        try (Closer closer = Closer.create();){
            f.createNewFile();
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(f));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ClipboardWriter writer = (ClipboardWriter)closer.register((Closeable)BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)bos));
            writer.write(clipboard);
        }
        catch (IOException e) {
            throw new CREIOException("Schematic could not read or it does not exist: " + e.getMessage(), t);
        }
    }

    public static void Rotate(MCCommandSender sender, int xaxis, int yaxis, int zaxis, Target t) {
        ClipboardHolder holder;
        Actor user = SKWorldEdit.GetActor(sender, t);
        LocalSession session = SKWorldEdit.GetLocalSession(user);
        try {
            holder = session.getClipboard();
        }
        catch (Exception e) {
            throw new CRENotFoundException("The clipboard is empty, copy something to it first!", t);
        }
        AffineTransform transform = new AffineTransform();
        transform = transform.rotateY((double)(-yaxis));
        transform = transform.rotateX((double)(-xaxis));
        transform = transform.rotateZ((double)(-zaxis));
        holder.setTransform(holder.getTransform().combine((Transform)transform));
    }

    public static void Paste(MCCommandSender sender, boolean airless, boolean biomes, boolean entities, boolean fastMode, boolean origin, boolean select, Target t) {
        BlockVector3 to;
        ClipboardHolder holder;
        Actor user = SKWorldEdit.GetActor(sender, t);
        LocalSession session = SKWorldEdit.GetLocalSession(user);
        EditSession editSession = SKWorldEdit.GetEditSession(user, fastMode);
        try {
            holder = session.getClipboard();
        }
        catch (Exception e) {
            throw new CRENotFoundException("The clipboard is empty, copy something to it first!", t);
        }
        Clipboard clipboard = holder.getClipboard();
        Region region = clipboard.getRegion();
        if (origin) {
            to = clipboard.getOrigin();
        } else {
            try {
                to = session.getPlacementPosition(user);
            }
            catch (IncompleteRegionException e) {
                throw new CRENotFoundException("Could not get paste location.", t);
            }
        }
        Operation operation = holder.createPaste((Extent)editSession).to(to).ignoreAirBlocks(airless).copyEntities(entities).copyBiomes(biomes).build();
        try {
            Operations.completeLegacy((Operation)operation);
            if (select) {
                BlockVector3 clipboardOffset = clipboard.getRegion().getMinimumPoint().subtract(clipboard.getOrigin());
                Vector3 realTo = to.toVector3().add(holder.getTransform().apply(clipboardOffset.toVector3()));
                Vector3 max = realTo.add(holder.getTransform().apply(region.getMaximumPoint().subtract(region.getMinimumPoint()).toVector3()));
                CuboidRegionSelector selector = new CuboidRegionSelector(editSession.getWorld(), realTo.toBlockPoint(), max.toBlockPoint());
                session.setRegionSelector(editSession.getWorld(), (RegionSelector)selector);
                selector.learnChanges();
                selector.explainRegionAdjust(user, session);
            }
        }
        catch (Exception e) {
            throw new CRERangeException("Attempted to change more blocks than allowed.", t);
        }
        finally {
            editSession.close();
        }
    }
}

