/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbaero.skcompat;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CRENotFoundException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Locatable;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import io.github.jbaero.skcompat.SKClipboard;
import io.github.jbaero.skcompat.SKCompat;
import io.github.jbaero.skcompat.SKConsole;
import io.github.jbaero.skcompat.SKMask;
import io.github.jbaero.skcompat.SKPattern;
import io.github.jbaero.skcompat.SKWorldEdit;
import java.io.File;
import java.nio.file.Path;
import org.bukkit.Location;

public class CHWorldEdit {
    public static String docs() {
        return "Provides various methods for hooking into WorldEdit.";
    }

    private static Mixed sk_posX_exec(Target t, Environment env, boolean primary, AbstractFunction caller, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
        MCCommandSender m = null;
        Mixed rawPos = null;
        if (args.length == 2) {
            m = SKWorldEdit.GetSender(args[0], t);
            rawPos = args[1];
        } else if (args.length == 1) {
            if (args[0] instanceof CArray) {
                rawPos = args[0];
            } else {
                m = SKWorldEdit.GetSender(args[0], t);
            }
        }
        if (m == null) {
            m = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
        }
        Actor user = SKWorldEdit.GetActor(m, t);
        LocalSession localSession = SKWorldEdit.GetLocalSession(user);
        if (rawPos != null) {
            if (rawPos instanceof CNull) {
                RegionSelector sel = localSession.getRegionSelector((World)((Locatable)user).getExtent());
                if (!(sel instanceof CuboidRegionSelector)) {
                    throw new CREPluginInternalException("Only cuboid regions are supported with " + caller.getName(), t);
                }
                BlockVector3 pos1 = ((CuboidRegionSelector)sel).getIncompleteRegion().getPos1();
                if (primary && pos1 == null) {
                    return CVoid.VOID;
                }
                BlockVector3 pos2 = ((CuboidRegionSelector)sel).getIncompleteRegion().getPos2();
                if (!primary && pos2 == null) {
                    return CVoid.VOID;
                }
                sel.clear();
                if (primary) {
                    pos1 = null;
                    if (pos2 != null) {
                        sel.selectSecondary(pos2, null);
                    }
                } else {
                    pos2 = null;
                    if (pos1 != null) {
                        sel.selectPrimary(pos1, null);
                    }
                }
                if (m instanceof MCPlayer) {
                    localSession.dispatchCUISelection(user);
                }
            } else {
                BlockVector3 blockPos;
                if (user instanceof SKConsole) {
                    MCLocation loc = ObjectGenerator.GetGenerator().location(rawPos, null, t);
                    ((Locatable)user).setLocation(BukkitAdapter.adapt((Location)((Location)loc.getHandle())));
                    blockPos = BlockVector3.at((double)Math.floor(loc.getX()), (double)Math.floor(loc.getY()), (double)Math.floor(loc.getZ()));
                } else {
                    Vector3D v = ObjectGenerator.GetGenerator().vector(rawPos, t);
                    blockPos = BlockVector3.at((double)Math.floor(v.X()), (double)Math.floor(v.Y()), (double)Math.floor(v.Z()));
                }
                RegionSelector sel = localSession.getRegionSelector((World)((Locatable)user).getExtent());
                if (!(sel instanceof CuboidRegionSelector)) {
                    throw new CREPluginInternalException("Only cuboid regions are supported with " + caller.getName(), t);
                }
                if (primary) {
                    sel.selectPrimary(blockPos, null);
                } else {
                    sel.selectSecondary(blockPos, null);
                }
                if (m instanceof MCPlayer) {
                    sel.explainRegionAdjust(user, localSession);
                }
            }
            return CVoid.VOID;
        }
        if (!((Locatable)user).getExtent().equals(localSession.getSelectionWorld())) {
            return CNull.NULL;
        }
        RegionSelector sel = localSession.getRegionSelector(localSession.getSelectionWorld());
        if (!(sel instanceof CuboidRegionSelector)) {
            throw new CREPluginInternalException("Only cuboid regions are supported with " + caller.getName(), t);
        }
        BlockVector3 pos = primary ? ((CuboidRegionSelector)sel).getIncompleteRegion().getPos1() : ((CuboidRegionSelector)sel).getIncompleteRegion().getPos2();
        return pos == BlockVector3.ZERO ? CNull.NULL : ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(pos));
    }

    @api
    public static class sk_clipboard_info
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_clipboard_info";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "array {[user]} Returns an array with selection info of the given user's clipboard (or null when the clipboard is empty). The returned array is in format: {origin:{x,y,z}, dimensions:{x,y,z}, minPoints{original:{x,y,z}, relative:{x,y,z}}, maxPoints{original:{x,y,z}, relative:{x,y,z}}}.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            ClipboardHolder clipHolder;
            Object sender = args.length == 0 ? ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer() : SKWorldEdit.GetSender(args[0], t);
            Actor user = SKWorldEdit.GetActor((MCCommandSender)sender, t);
            LocalSession localSession = SKWorldEdit.GetLocalSession(user);
            try {
                clipHolder = localSession.getClipboard();
            }
            catch (Exception e) {
                return CNull.NULL;
            }
            Clipboard clip = clipHolder.getClipboard();
            Transform transform = clipHolder.getTransform();
            CArray ret = new CArray(t);
            CArray origin = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getOrigin()));
            CArray dimensions = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getDimensions()));
            CArray minPointOriginal = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getMinimumPoint()));
            CArray maxPointOriginal = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getMaximumPoint()));
            CArray minPointRelative = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getMinimumPoint().subtract(clip.getOrigin())));
            CArray maxPointRelative = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(clip.getMaximumPoint().subtract(clip.getOrigin())));
            CArray minPoint = new CArray(t);
            CArray maxPoint = new CArray(t);
            minPoint.set("original", (Mixed)minPointOriginal, t);
            maxPoint.set("original", (Mixed)maxPointOriginal, t);
            minPoint.set("relative", (Mixed)minPointRelative, t);
            maxPoint.set("relative", (Mixed)maxPointRelative, t);
            ret.set("origin", (Mixed)origin, t);
            ret.set("dimensions", (Mixed)dimensions, t);
            ret.set("minPoint", (Mixed)minPoint, t);
            ret.set("maxPoint", (Mixed)maxPoint, t);
            if (!(transform instanceof AffineTransform)) {
                return ret;
            }
            AffineTransform affineTransform = (AffineTransform)transform;
            Vector3 minPointOriginalVec = affineTransform.apply(clip.getMinimumPoint().subtract(clip.getOrigin()).toVector3()).add(clip.getOrigin().toVector3());
            Vector3 maxPointOriginalVec = affineTransform.apply(clip.getMaximumPoint().subtract(clip.getOrigin()).toVector3()).add(clip.getOrigin().toVector3());
            Vector3 minPointRelativeVec = affineTransform.apply(clip.getMinimumPoint().subtract(clip.getOrigin()).toVector3());
            Vector3 maxPointRelativeVec = affineTransform.apply(clip.getMaximumPoint().subtract(clip.getOrigin()).toVector3());
            CArray minPointOriginalCVec = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(minPointOriginalVec.toBlockPoint()));
            CArray maxPointOriginalCVec = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(maxPointOriginalVec.toBlockPoint()));
            CArray minPointRelativeCVec = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(minPointRelativeVec.toBlockPoint()));
            CArray maxPointRelativeCVec = ObjectGenerator.GetGenerator().vector(SKWorldEdit.vtov(maxPointRelativeVec.toBlockPoint()));
            minPoint.set("original", (Mixed)minPointOriginalCVec, t);
            maxPoint.set("original", (Mixed)maxPointOriginalCVec, t);
            minPoint.set("relative", (Mixed)minPointRelativeCVec, t);
            maxPoint.set("relative", (Mixed)maxPointRelativeCVec, t);
            return ret;
        }
    }

    @api
    public static class sk_schematic_exists
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENotFoundException.class, CRECastException.class, CREInvalidPluginException.class, CREIOException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            File f;
            WorldEdit worldEdit = WorldEdit.getInstance();
            String filename = args[0].val();
            Path dir = worldEdit.getWorkingDirectoryPath(worldEdit.getConfiguration().saveDir);
            try {
                f = worldEdit.getSafeOpenFile(null, dir.toFile(), filename, "schem", new String[0]);
            }
            catch (Exception fne) {
                throw new CREFormatException(fne.getMessage(), t);
            }
            return CBoolean.get((boolean)f.exists());
        }

        public String getName() {
            return "sk_schematic_exists";
        }

        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        public String docs() {
            return "boolean {filename} Returns whether a schematic by that name exists. It will use the directory specified in WorldEdit's config. If an extension is not provided, 'filename.schem' will be checked. Ignores legacy schematics unless the legacy extension is explicitly used. Throws FormatException if using an invalid filename.";
        }
    }

    @api
    public static class skcb_clear
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRECastException.class, CREInvalidPluginException.class, CRELengthException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            MCCommandSender sender = null;
            if (args.length == 1) {
                sender = SKWorldEdit.GetSender(args[0], t);
            }
            Actor user = SKWorldEdit.GetActor(sender, t);
            SKWorldEdit.GetLocalSession(user).setClipboard(null);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_clear";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        public String docs() {
            return "void {[user]} Clears the clipboard for the specified player or console.";
        }
    }

    @api
    public static class skcb_paste
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidWorldException.class, CREFormatException.class, CRERangeException.class, CRENotFoundException.class, CRECastException.class, CREInvalidPluginException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean airless = false;
            boolean fastMode = false;
            boolean origin = false;
            boolean select = false;
            boolean entities = false;
            boolean biomes = false;
            MCCommandSender sender = null;
            if (args[0] instanceof CArray) {
                MCLocation l = ObjectGenerator.GetGenerator().location(args[0], null, t);
                ((Locatable)SKWorldEdit.GetActor(null, t)).setLocation(BukkitAdapter.adapt((Location)((Location)l.getHandle())));
            } else {
                sender = SKWorldEdit.GetSender(args[0], t);
            }
            if (args.length >= 2) {
                CArray options = ArgumentValidation.getArray((Mixed)args[1], (Target)t);
                if (options.containsKey("airless")) {
                    airless = ArgumentValidation.getBooleanObject((Mixed)options.get("airless", t), (Target)t);
                }
                if (options.containsKey("fastmode")) {
                    fastMode = ArgumentValidation.getBooleanObject((Mixed)options.get("fastmode", t), (Target)t);
                }
                if (options.containsKey("origin")) {
                    origin = ArgumentValidation.getBooleanObject((Mixed)options.get("origin", t), (Target)t);
                }
                if (options.containsKey("select")) {
                    select = ArgumentValidation.getBooleanObject((Mixed)options.get("select", t), (Target)t);
                }
                if (options.containsKey("entities")) {
                    entities = ArgumentValidation.getBooleanObject((Mixed)options.get("entities", t), (Target)t);
                }
                if (options.containsKey("biomes")) {
                    biomes = ArgumentValidation.getBooleanObject((Mixed)options.get("biomes", t), (Target)t);
                }
            }
            SKClipboard.Paste(sender, airless, biomes, entities, fastMode, origin, select, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_paste";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {location | user, [options]} Pastes a schematic from the user's clipboard if a user is provided, or from the console's clipboard if a location is given, as if a player was standing there. An associative array of options can be provided, all of which default to false. If 'airless' is true, air blocks from the schematic will not replace blocks in the world. If 'fastmode' is true, the function will use WorldEdit's 'fastmode' to paste. If 'origin' is true, the schematic will be pasted at the original location it was copied from. If 'select' is true, the pasted blocks will be automatically selected. If 'entities' is true, entities within the schematic will be pasted. If 'biomes' is true, the biomes within the schematic with be pasted.";
        }
    }

    @api
    public static class skcb_rotate
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CRENotFoundException.class, CREPlayerOfflineException.class, CRERangeException.class, CRECastException.class, CREIllegalArgumentException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            int yaxis = 0;
            int xaxis = 0;
            int zaxis = 0;
            MCCommandSender sender = null;
            switch (args.length) {
                case 3: {
                    xaxis = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
                    zaxis = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
                }
                case 1: {
                    yaxis = ArgumentValidation.getInt32((Mixed)args[0], (Target)t);
                    break;
                }
                case 4: {
                    xaxis = ArgumentValidation.getInt32((Mixed)args[2], (Target)t);
                    zaxis = ArgumentValidation.getInt32((Mixed)args[3], (Target)t);
                }
                case 2: {
                    yaxis = ArgumentValidation.getInt32((Mixed)args[1], (Target)t);
                    sender = SKWorldEdit.GetSender(args[0], t);
                }
            }
            if (yaxis % 90 != 0 || xaxis % 90 != 0 || zaxis % 90 != 0) {
                throw new CREIllegalArgumentException("Axes must be multiples of 90 degrees.", t);
            }
            SKClipboard.Rotate(sender, xaxis, yaxis, zaxis, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_rotate";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2, 3, 4};
        }

        public String docs() {
            return "void {[user,] int y-axis, [int x-axis, int z-axis]} Rotates the clipboard by the given (multiple of 90) degrees for each corresponding axis. To skip an axis, simply give it a value of 0. If a player is supplied, theirs will be rotated, otherwise the console will be used.";
        }
    }

    @api
    public static class skcb_save
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class, CREPlayerOfflineException.class, CREIOException.class, CREInvalidPluginException.class, CRELengthException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String filename = args[0].val();
            MCCommandSender sender = null;
            if (args.length > 1) {
                sender = SKWorldEdit.GetSender(args[1], t);
            }
            SKClipboard.Save(sender, filename, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_save";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {filename, [user]} Saves a schematic in the clipboard to file. It will use the directory specified in WorldEdit's config. By default it will use the console's clipboard, but will use a player's if specified.";
        }
    }

    @api
    public static class skcb_load
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class, CREPlayerOfflineException.class, CREIOException.class, CREInvalidPluginException.class, CRELengthException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String filename = args[0].val();
            MCCommandSender sender = null;
            if (args.length == 2) {
                sender = SKWorldEdit.GetSender(args[1], t);
            }
            SKClipboard.Load(sender, filename, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_load";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {filename, [user]} Loads a schematic into the clipboard from file. It will use the directory specified in WorldEdit's config. By default it will use the console's clipboard, but will use a player's if specified.";
        }
    }

    @api
    public static class skcb_copy
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class, CREPlayerOfflineException.class, CREIOException.class, CREInvalidPluginException.class, CRELengthException.class, CREFormatException.class};
        }

        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            boolean entities = false;
            boolean biomes = false;
            MCCommandSender sender = null;
            MCLocation loc = null;
            if (args[0] instanceof CArray) {
                loc = ObjectGenerator.GetGenerator().location(args[0], null, t);
            } else {
                sender = SKWorldEdit.GetSender(args[0], t);
            }
            if (args.length == 2) {
                CArray options = ArgumentValidation.getArray((Mixed)args[1], (Target)t);
                if (options.containsKey("entities")) {
                    entities = ArgumentValidation.getBooleanObject((Mixed)options.get("entities", t), (Target)t);
                }
                if (options.containsKey("biomes")) {
                    biomes = ArgumentValidation.getBooleanObject((Mixed)options.get("biomes", t), (Target)t);
                }
            }
            SKClipboard.Copy(sender, loc, entities, biomes, t);
            return CVoid.VOID;
        }

        public String getName() {
            return "skcb_copy";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {location | user, [options]} Copies the selected region into the clipboard. If a location is specified it will use the console's clipboard and the location will be used as the origin point for the clipboard. If ~console is explicitly specified instead, it will use the last set position as the origin. An associative array of options can be provided, all of which default to false. If 'entities' is true, entities within the schematic will be pasted. If 'biomes' is true, the biomes within the schematic with be pasted.";
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_replace_blocks
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CREPlayerOfflineException.class, CREFormatException.class, CRECastException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Mixed pat;
            String maskInput;
            MCCommandSender sender;
            if (args.length == 3) {
                sender = SKWorldEdit.GetSender(args[0], t);
                maskInput = args[1].val();
                pat = args[2];
            } else {
                sender = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                maskInput = args[0].val();
                pat = args[1];
            }
            Actor user = SKWorldEdit.GetActor(sender, t);
            LocalSession localSession = SKWorldEdit.GetLocalSession(user);
            SKPattern pattern = new SKPattern();
            if (pat instanceof CArray) {
                pattern.generateBlockPattern((CArray)pat, user, t);
            } else if (pat instanceof CString) {
                pattern.generateBlockPattern((CString)pat, user, t);
            } else {
                throw new CREFormatException("Invalid block pattern.", t);
            }
            SKMask mask = new SKMask();
            mask.generateMask(maskInput, user, t);
            try (EditSession editSession = SKWorldEdit.GetEditSession(user, false);){
                editSession.replaceBlocks(localSession.getSelection(), mask.getHandle(), pattern.getHandle());
            }
            catch (Exception wee) {
                throw new CREPluginInternalException(wee.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "sk_replace_blocks";
        }

        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        public String docs() {
            return "void {[user], mask, pattern} Replaces blocks matching the mask with a block pattern. The mask and pattern can be a string in the format given to WorldEdit commands. Patterns can also be a normal array of associative arrays. The inner arrays consist of a required 'block' field describing the block's material and properties, and an optional decimal 'weight' field. If weight is not given it defaults to 1. The weight represents that block's chance of being selected for the next random block setting. If the pattern array is empty, the entire selection will be set to air.";
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_setblock
    extends SKCompat.SKFunction {
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidPluginException.class, CREPluginInternalException.class, CREPlayerOfflineException.class, CREFormatException.class, CRECastException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            Mixed pat;
            MCCommandSender sender;
            if (args.length == 2) {
                sender = SKWorldEdit.GetSender(args[0], t);
                pat = args[1];
            } else {
                sender = ((CommandHelperEnvironment)env.getEnv(CommandHelperEnvironment.class)).GetPlayer();
                pat = args[0];
            }
            Actor user = SKWorldEdit.GetActor(sender, t);
            SKPattern pattern = new SKPattern();
            if (pat instanceof CArray) {
                pattern.generateBlockPattern((CArray)pat, user, t);
            } else if (pat instanceof CString) {
                pattern.generateBlockPattern((CString)pat, user, t);
            } else {
                throw new CREFormatException("Invalid block pattern.", t);
            }
            LocalSession localSession = SKWorldEdit.GetLocalSession(user);
            try (EditSession editSession = SKWorldEdit.GetEditSession(user, false);){
                editSession.setBlocks(localSession.getSelection(), pattern.getHandle());
            }
            catch (Exception wee) {
                throw new CREPluginInternalException(wee.getMessage(), t);
            }
            return CVoid.VOID;
        }

        public String getName() {
            return "sk_setblock";
        }

        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        public String docs() {
            return "void {[user], pattern} Sets the current selection to blocks defined by the provided block pattern. The pattern can be a string in the format given to WorldEdit commands, or it can be a normal array of associative arrays. The inner arrays consist of a required 'block' field describing the block's array material and properties, and an optional decimal 'weight' field. If weight is not given it defaults to 1. The weight represents that block's chance of being selected for the next random block setting. If the pattern array is empty, the entire selection will be set to air.";
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_pos2
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_pos2";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        public String docs() {
            return "mixed {[user], array | [user] | array} Sets or gets the user's point 2. If an array is given, sets the user's point 2 to the given location array. If the array is null, the point will be cleared. If no array is given, current point 2 of the user will be returned as an array in format array(0: xVal, 1: yVal, 2: zVal, x: xVal, y: yVal, z: zVal) or null when the point has not been set. In case " + this.getName() + "(null) is called, the argument will be treated as user.";
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRECastException.class};
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return CHWorldEdit.sk_posX_exec(t, env, false, this, args);
        }
    }

    @api(environments={CommandHelperEnvironment.class})
    public static class sk_pos1
    extends SKCompat.SKFunction {
        public String getName() {
            return "sk_pos1";
        }

        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPlayerOfflineException.class, CRECastException.class};
        }

        public String docs() {
            return "mixed {[user], array | [user] | array} Sets or gets the user's point 1. If an array is given, sets the user's point 1 to the given location array. If the array is null, the point will be cleared. If no array is given, current point 1 of the user will be returned as an array in format array(0: xVal, 1: yVal, 2: zVal, x: xVal, y: yVal, z: zVal) or null when the point has not been set. In case " + this.getName() + "(null) is called, the argument will be treated as user.";
        }

        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return CHWorldEdit.sk_posX_exec(t, env, true, this, args);
        }
    }
}

