/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.EconomyHandler;
import net.TheDgtl.Stargate.RelativeBlockVector;
import net.TheDgtl.Stargate.Stargate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;

public class Gate {
    private static final Character ANYTHING = Character.valueOf(' ');
    private static final Character ENTRANCE = Character.valueOf('.');
    private static final Character EXIT = Character.valueOf('*');
    private static final HashMap<String, Gate> gates = new HashMap();
    private static final HashMap<Material, ArrayList<Gate>> controlBlocks = new HashMap();
    private static final HashSet<Material> frameBlocks = new HashSet();
    private final String filename;
    private final Character[][] layout;
    private final HashMap<Character, Material> types;
    private RelativeBlockVector[] entrances = new RelativeBlockVector[0];
    private RelativeBlockVector[] border = new RelativeBlockVector[0];
    private RelativeBlockVector[] controls = new RelativeBlockVector[0];
    private RelativeBlockVector exitBlock = null;
    private final HashMap<RelativeBlockVector, Integer> exits = new HashMap();
    private Material portalBlockOpen = Material.NETHER_PORTAL;
    private Material portalBlockClosed = Material.AIR;
    private Material button = Material.STONE_BUTTON;
    private int useCost = -1;
    private int createCost = -1;
    private int destroyCost = -1;
    private boolean toOwner = false;

    public Gate(String filename, Character[][] layout, HashMap<Character, Material> types) {
        this.filename = filename;
        this.layout = layout;
        this.types = types;
        this.populateCoordinates();
    }

    private void populateCoordinates() {
        int x;
        ArrayList<RelativeBlockVector> entranceList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> borderList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> controlList = new ArrayList<RelativeBlockVector>();
        RelativeBlockVector[] relativeExits = new RelativeBlockVector[this.layout[0].length];
        int[] exitDepths = new int[this.layout[0].length];
        RelativeBlockVector lastExit = null;
        for (int y = 0; y < this.layout.length; ++y) {
            for (int x2 = 0; x2 < this.layout[y].length; ++x2) {
                Character key = this.layout[y][x2];
                if (key.equals(Character.valueOf('-'))) {
                    controlList.add(new RelativeBlockVector(x2, y, 0));
                }
                if (key.equals(ENTRANCE) || key.equals(EXIT)) {
                    entranceList.add(new RelativeBlockVector(x2, y, 0));
                    exitDepths[x2] = y;
                    if (!key.equals(EXIT)) continue;
                    this.exitBlock = new RelativeBlockVector(x2, y, 0);
                    continue;
                }
                if (key.equals(ANYTHING)) continue;
                borderList.add(new RelativeBlockVector(x2, y, 0));
            }
        }
        for (x = 0; x < exitDepths.length; ++x) {
            relativeExits[x] = new RelativeBlockVector(x, exitDepths[x], 0);
        }
        for (x = relativeExits.length - 1; x >= 0; --x) {
            if (relativeExits[x] != null) {
                lastExit = relativeExits[x];
            } else {
                relativeExits[x] = lastExit;
            }
            if (exitDepths[x] <= 0) continue;
            this.exits.put(relativeExits[x], x);
        }
        this.entrances = entranceList.toArray(this.entrances);
        this.border = borderList.toArray(this.border);
        this.controls = controlList.toArray(this.controls);
    }

    public void save(String gateFolder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(gateFolder + this.filename));
            this.writeConfig(bw, "portal-open", this.portalBlockOpen.name());
            this.writeConfig(bw, "portal-closed", this.portalBlockClosed.name());
            this.writeConfig(bw, "button", this.button.name());
            if (this.useCost != -1) {
                this.writeConfig(bw, "usecost", this.useCost);
            }
            if (this.createCost != -1) {
                this.writeConfig(bw, "createcost", this.createCost);
            }
            if (this.destroyCost != -1) {
                this.writeConfig(bw, "destroycost", this.destroyCost);
            }
            this.writeConfig(bw, "toowner", this.toOwner);
            for (Map.Entry<Character, Material> entry : this.types.entrySet()) {
                Character type = entry.getKey();
                Material value = entry.getValue();
                if (type.equals(ANYTHING) || type.equals(ENTRANCE) || type.equals(EXIT)) continue;
                bw.append(type.charValue());
                bw.append('=');
                if (value != null) {
                    bw.append(value.toString());
                }
                bw.newLine();
            }
            bw.newLine();
            Character[][] characterArray = this.layout;
            int n = characterArray.length;
            for (int i = 0; i < n; ++i) {
                Character[] aLayout;
                for (Character symbol : aLayout = characterArray[i]) {
                    bw.append(symbol.charValue());
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException ex) {
            Stargate.log.log(Level.SEVERE, "Could not save Gate " + this.filename + " - " + ex.getMessage());
        }
    }

    private void writeConfig(BufferedWriter bw, String key, int value) throws IOException {
        bw.append(String.format("%s=%d", key, value));
        bw.newLine();
    }

    private void writeConfig(BufferedWriter bw, String key, boolean value) throws IOException {
        bw.append(String.format("%s=%b", key, value));
        bw.newLine();
    }

    private void writeConfig(BufferedWriter bw, String key, String value) throws IOException {
        bw.append(String.format("%s=%s", key, value));
        bw.newLine();
    }

    public Character[][] getLayout() {
        return this.layout;
    }

    public HashMap<Character, Material> getTypes() {
        return this.types;
    }

    public RelativeBlockVector[] getEntrances() {
        return this.entrances;
    }

    public RelativeBlockVector[] getBorder() {
        return this.border;
    }

    public RelativeBlockVector[] getControls() {
        return this.controls;
    }

    public HashMap<RelativeBlockVector, Integer> getExits() {
        return this.exits;
    }

    public RelativeBlockVector getExit() {
        return this.exitBlock;
    }

    public Material getControlBlock() {
        return this.types.get(Character.valueOf('-'));
    }

    public String getFilename() {
        return this.filename;
    }

    public Material getPortalBlockOpen() {
        return this.portalBlockOpen;
    }

    public void setPortalBlockOpen(Material type) {
        this.portalBlockOpen = type;
    }

    public Material getPortalBlockClosed() {
        return this.portalBlockClosed;
    }

    public void setPortalBlockClosed(Material type) {
        this.portalBlockClosed = type;
    }

    public Material getButton() {
        return this.button;
    }

    public int getUseCost() {
        if (this.useCost < 0) {
            return EconomyHandler.useCost;
        }
        return this.useCost;
    }

    public Integer getCreateCost() {
        if (this.createCost < 0) {
            return EconomyHandler.createCost;
        }
        return this.createCost;
    }

    public Integer getDestroyCost() {
        if (this.destroyCost < 0) {
            return EconomyHandler.destroyCost;
        }
        return this.destroyCost;
    }

    public Boolean getToOwner() {
        return this.toOwner;
    }

    public boolean matches(Blox topleft, int modX, int modZ) {
        return this.matches(topleft, modX, modZ, false);
    }

    public boolean matches(Blox topleft, int modX, int modZ, boolean onCreate) {
        HashMap<Character, Material> portalTypes = new HashMap<Character, Material>(this.types);
        for (int y = 0; y < this.layout.length; ++y) {
            for (int x = 0; x < this.layout[y].length; ++x) {
                Character key = this.layout[y][x];
                if (key.equals(ENTRANCE) || key.equals(EXIT)) {
                    if (Stargate.ignoreEntrance) continue;
                    Material type = topleft.modRelative(x, y, 0, modX, 1, modZ).getType();
                    if (onCreate && type == Material.AIR || type == this.portalBlockClosed || type == this.portalBlockOpen) continue;
                    Stargate.debug("Gate::Matches", "Entrance/Exit Material Mismatch: " + type);
                    return false;
                }
                if (key.equals(ANYTHING)) continue;
                Material id = portalTypes.get(key);
                if (id == null) {
                    portalTypes.put(key, topleft.modRelative(x, y, 0, modX, 1, modZ).getType());
                    continue;
                }
                if (topleft.modRelative(x, y, 0, modX, 1, modZ).getType() == id) continue;
                Stargate.debug("Gate::Matches", "Block Type Mismatch: " + topleft.modRelative(x, y, 0, modX, 1, modZ).getType() + " != " + id);
                return false;
            }
        }
        return true;
    }

    public static void registerGate(Gate gate) {
        gates.put(gate.getFilename(), gate);
        Material blockID = gate.getControlBlock();
        if (!controlBlocks.containsKey(blockID)) {
            controlBlocks.put(blockID, new ArrayList());
        }
        controlBlocks.get(blockID).add(gate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gate loadGate(File file) {
        String[] split;
        Scanner scanner = null;
        boolean designing = false;
        ArrayList design = new ArrayList();
        HashMap<Character, Material> types = new HashMap<Character, Material>();
        HashMap<String, String> config = new HashMap<String, String>();
        HashSet<Material> frameTypes = new HashSet<Material>();
        int cols = 0;
        types.put(ENTRANCE, Material.AIR);
        types.put(EXIT, Material.AIR);
        types.put(ANYTHING, Material.AIR);
        try {
            scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (designing) {
                    ArrayList<Character> row = new ArrayList<Character>();
                    if (line.length() > cols) {
                        cols = line.length();
                    }
                    char[] cArray = line.toCharArray();
                    int n = cArray.length;
                    for (int i = 0; i < n; ++i) {
                        Character symbol = Character.valueOf(cArray[i]);
                        if (symbol.equals(Character.valueOf('?')) || !types.containsKey(symbol)) {
                            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Unknown symbol '" + symbol + "' in diagram");
                            Gate gate = null;
                            return gate;
                        }
                        row.add(symbol);
                    }
                    design.add(row);
                    continue;
                }
                if (line.isEmpty() || !line.contains("=")) {
                    designing = true;
                    continue;
                }
                split = line.split("=");
                String key = split[0].trim();
                String value = split[1].trim();
                if (key.length() == 1) {
                    Character symbol = Character.valueOf(key.charAt(0));
                    Material id = Material.getMaterial((String)value);
                    if (id == null) {
                        throw new Exception("Invalid material in line: " + line);
                    }
                    types.put(symbol, id);
                    frameTypes.add(id);
                    continue;
                }
                config.put(key, value);
            }
        }
        catch (Exception ex) {
            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - " + ex.getMessage());
            split = null;
            return split;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        Character[][] layout = new Character[design.size()][cols];
        for (int y = 0; y < design.size(); ++y) {
            ArrayList row = (ArrayList)design.get(y);
            Character[] result = new Character[cols];
            for (int x = 0; x < cols; ++x) {
                result[x] = x < row.size() ? (Character)row.get(x) : Character.valueOf(' ');
            }
            layout[y] = result;
        }
        Gate gate = new Gate(file.getName(), layout, types);
        gate.portalBlockOpen = Gate.readConfig(config, gate, file, "portal-open", gate.portalBlockOpen);
        gate.portalBlockClosed = Gate.readConfig(config, gate, file, "portal-closed", gate.portalBlockClosed);
        gate.button = Gate.readConfig(config, gate, file, "button", gate.button);
        gate.useCost = Gate.readConfig(config, gate, file, "usecost", -1);
        gate.destroyCost = Gate.readConfig(config, gate, file, "destroycost", -1);
        gate.createCost = Gate.readConfig(config, gate, file, "createcost", -1);
        boolean bl = gate.toOwner = config.containsKey("toowner") ? Boolean.valueOf(config.get("toowner")) : EconomyHandler.toOwner;
        if (gate.getControls().length != 2) {
            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Gates must have exactly 2 control points.");
            return null;
        }
        if (!Tag.BUTTONS.isTagged((Keyed)gate.button)) {
            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Gate button must be a type of button.");
            return null;
        }
        frameBlocks.addAll(frameTypes);
        gate.save(file.getParent() + "/");
        return gate;
    }

    private static int readConfig(HashMap<String, String> config, Gate gate, File file, String key, int def) {
        if (config.containsKey(key)) {
            try {
                return Integer.parseInt(config.get(key));
            }
            catch (NumberFormatException ex) {
                Stargate.log.log(Level.WARNING, String.format("%s reading %s: %s is not numeric", ex.getClass().getName(), file, key));
            }
        }
        return def;
    }

    private static Material readConfig(HashMap<String, String> config, Gate gate, File file, String key, Material def) {
        if (config.containsKey(key)) {
            Material mat = Material.getMaterial((String)config.get(key));
            if (mat != null) {
                return mat;
            }
            Stargate.log.log(Level.WARNING, String.format("Error reading %s: %s is not a material", file, key));
        }
        return def;
    }

    public static void loadGates(String gateFolder) {
        File dir = new File(gateFolder);
        File[] files = dir.exists() ? dir.listFiles(new StargateFilenameFilter()) : new File[]{};
        if (files == null || files.length == 0) {
            if (dir.mkdir()) {
                Gate.populateDefaults(gateFolder);
            }
        } else {
            for (File file : files) {
                Gate gate = Gate.loadGate(file);
                if (gate == null) continue;
                Gate.registerGate(gate);
            }
        }
    }

    public static void populateDefaults(String gateFolder) {
        Character[][] layout = new Character[][]{{Character.valueOf(' '), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf(' ')}, {Character.valueOf('X'), Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('X')}, {Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('-')}, {Character.valueOf('X'), Character.valueOf('*'), Character.valueOf('.'), Character.valueOf('X')}, {Character.valueOf(' '), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf(' ')}};
        HashMap<Character, Material> types = new HashMap<Character, Material>();
        types.put(ENTRANCE, Material.AIR);
        types.put(EXIT, Material.AIR);
        types.put(ANYTHING, Material.AIR);
        types.put(Character.valueOf('X'), Material.OBSIDIAN);
        types.put(Character.valueOf('-'), Material.OBSIDIAN);
        Gate gate = new Gate("nethergate.gate", layout, types);
        gate.save(gateFolder);
        Gate.registerGate(gate);
    }

    public static Gate[] getGatesByControlBlock(Block block) {
        return Gate.getGatesByControlBlock(block.getType());
    }

    public static Gate[] getGatesByControlBlock(Material type) {
        Gate[] result = new Gate[]{};
        ArrayList<Gate> lookup = controlBlocks.get(type);
        if (lookup != null) {
            result = lookup.toArray(result);
        }
        return result;
    }

    public static Gate getGateByName(String name) {
        return gates.get(name);
    }

    public static int getGateCount() {
        return gates.size();
    }

    public static boolean isGateBlock(Material type) {
        return frameBlocks.contains(type);
    }

    public static void clearGates() {
        gates.clear();
        controlBlocks.clear();
        frameBlocks.clear();
    }

    static class StargateFilenameFilter
    implements FilenameFilter {
        StargateFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".gate");
        }
    }
}

