/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.TheDgtl.Stargate.BloxPopulator;
import net.TheDgtl.Stargate.EconomyHandler;
import net.TheDgtl.Stargate.Gate;
import net.TheDgtl.Stargate.LangLoader;
import net.TheDgtl.Stargate.Portal;
import net.TheDgtl.Stargate.event.StargateAccessEvent;
import net.TheDgtl.Stargate.event.StargateDestroyEvent;
import net.TheDgtl.Stargate.pmListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.EndGateway;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Stargate
extends JavaPlugin {
    public static Logger log;
    private FileConfiguration newConfig;
    private PluginManager pm;
    public static Server server;
    public static Stargate stargate;
    private static LangLoader lang;
    private static String portalFolder;
    private static String gateFolder;
    private static String langFolder;
    private static String defNetwork;
    private static boolean destroyExplosion;
    public static int maxGates;
    private static String langName;
    private static final int activeTime = 10;
    private static final int openTime = 10;
    public static boolean destMemory;
    public static boolean handleVehicles;
    public static boolean sortLists;
    public static boolean protectEntrance;
    public static boolean enableBungee;
    public static boolean verifyPortals;
    public static ChatColor signColor;
    public static boolean ignoreEntrance;
    public static boolean debug;
    public static boolean permDebug;
    public static ConcurrentLinkedQueue<Portal> openList;
    public static ConcurrentLinkedQueue<Portal> activeList;
    public static Queue<BloxPopulator> blockPopulatorQueue;
    public static Map<String, String> bungeeQueue;
    public static HashSet<String> managedWorlds;

    public void onDisable() {
        Portal.closeAllGates();
        Portal.clearGates();
        managedWorlds.clear();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.pm = this.getServer().getPluginManager();
        this.newConfig = this.getConfig();
        log = Logger.getLogger("Minecraft");
        server = this.getServer();
        stargate = this;
        portalFolder = this.getDataFolder().getPath().replaceAll("\\\\", "/") + "/portals/";
        gateFolder = this.getDataFolder().getPath().replaceAll("\\\\", "/") + "/gates/";
        langFolder = this.getDataFolder().getPath().replaceAll("\\\\", "/") + "/lang/";
        log.info(pdfFile.getName() + " v." + pdfFile.getVersion() + " is enabled.");
        this.pm.registerEvents((Listener)new pListener(), (Plugin)this);
        this.pm.registerEvents((Listener)new bListener(), (Plugin)this);
        this.pm.registerEvents((Listener)new vListener(), (Plugin)this);
        this.pm.registerEvents((Listener)new eListener(), (Plugin)this);
        this.pm.registerEvents((Listener)new wListener(), (Plugin)this);
        this.pm.registerEvents((Listener)new sListener(), (Plugin)this);
        this.loadConfig();
        if (enableBungee) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)new pmListener());
        }
        lang = new LangLoader(langFolder, langName);
        this.migrate();
        this.loadGates();
        this.loadAllPortals();
        if (EconomyHandler.setupEconomy(this.pm) && EconomyHandler.economy != null) {
            log.info("[Stargate] Vault v" + EconomyHandler.vault.getDescription().getVersion() + " found");
        }
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new SGThread(), 0L, 100L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new BlockPopulatorThread(), 0L, 1L);
    }

    public void loadConfig() {
        this.reloadConfig();
        this.newConfig = this.getConfig();
        this.newConfig.options().copyDefaults(true);
        portalFolder = this.newConfig.getString("portal-folder");
        gateFolder = this.newConfig.getString("gate-folder");
        defNetwork = this.newConfig.getString("default-gate-network").trim();
        destroyExplosion = this.newConfig.getBoolean("destroyexplosion");
        maxGates = this.newConfig.getInt("maxgates");
        langName = this.newConfig.getString("lang");
        destMemory = this.newConfig.getBoolean("destMemory");
        ignoreEntrance = this.newConfig.getBoolean("ignoreEntrance");
        handleVehicles = this.newConfig.getBoolean("handleVehicles");
        sortLists = this.newConfig.getBoolean("sortLists");
        protectEntrance = this.newConfig.getBoolean("protectEntrance");
        enableBungee = this.newConfig.getBoolean("enableBungee");
        verifyPortals = this.newConfig.getBoolean("verifyPortals");
        String sc = this.newConfig.getString("signColor");
        try {
            signColor = ChatColor.valueOf((String)sc.toUpperCase());
        }
        catch (Exception ignore) {
            log.warning("[Stargate] You have specified an invalid color in your config.yml. Defaulting to BLACK");
            signColor = ChatColor.BLACK;
        }
        debug = this.newConfig.getBoolean("debug");
        permDebug = this.newConfig.getBoolean("permdebug");
        EconomyHandler.economyEnabled = this.newConfig.getBoolean("useeconomy");
        EconomyHandler.createCost = this.newConfig.getInt("createcost");
        EconomyHandler.destroyCost = this.newConfig.getInt("destroycost");
        EconomyHandler.useCost = this.newConfig.getInt("usecost");
        EconomyHandler.toOwner = this.newConfig.getBoolean("toowner");
        EconomyHandler.chargeFreeDestination = this.newConfig.getBoolean("chargefreedestination");
        EconomyHandler.freeGatesGreen = this.newConfig.getBoolean("freegatesgreen");
        this.saveConfig();
    }

    public void closeAllPortals() {
        for (Portal p : openList) {
            p.close(true);
        }
    }

    public void loadGates() {
        Gate.loadGates(gateFolder);
        log.info("[Stargate] Loaded " + Gate.getGateCount() + " gate layouts");
    }

    public void loadAllPortals() {
        for (World world : this.getServer().getWorlds()) {
            if (managedWorlds.contains(world.getName())) continue;
            Portal.loadAllGates(world);
            managedWorlds.add(world.getName());
        }
    }

    private void migrate() {
        File newFile;
        File newPortalDir = new File(portalFolder);
        if (!newPortalDir.exists()) {
            newPortalDir.mkdirs();
        }
        if (!(newFile = new File(portalFolder, ((World)this.getServer().getWorlds().get(0)).getName() + ".db")).exists()) {
            newFile.getParentFile().mkdirs();
        }
    }

    public static void debug(String rout, String msg) {
        if (debug) {
            log.info("[Stargate::" + rout + "] " + msg);
        } else {
            log.log(Level.FINEST, "[Stargate::" + rout + "] " + msg);
        }
    }

    public static void sendMessage(CommandSender player, String message) {
        Stargate.sendMessage(player, message, true);
    }

    public static void sendMessage(CommandSender player, String message, boolean error) {
        if (message.isEmpty()) {
            return;
        }
        message = message.replaceAll("(&([a-f0-9]))", "\u00a7$2");
        if (error) {
            player.sendMessage(ChatColor.RED + Stargate.getString("prefix") + ChatColor.WHITE + message);
        } else {
            player.sendMessage(ChatColor.GREEN + Stargate.getString("prefix") + ChatColor.WHITE + message);
        }
    }

    public static void setLine(Sign sign, int index, String text) {
        sign.setLine(index, signColor + text);
    }

    public static String getSaveLocation() {
        return portalFolder;
    }

    public static String getGateFolder() {
        return gateFolder;
    }

    public static String getDefaultNetwork() {
        return defNetwork;
    }

    public static String getString(String name) {
        return lang.getString(name);
    }

    public static void openPortal(Player player, Portal portal) {
        Portal destination = portal.getDestination();
        if (portal.isAlwaysOn()) {
            return;
        }
        if (portal.isRandom()) {
            return;
        }
        if (destination == null || destination == portal) {
            Stargate.sendMessage((CommandSender)player, Stargate.getString("invalidMsg"));
            return;
        }
        if (portal.isOpen()) {
            if (portal.getActivePlayer() == player) {
                portal.close(false);
            }
            return;
        }
        if (!portal.isFixed() && portal.isActive() && portal.getActivePlayer() != player) {
            Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
            return;
        }
        if (portal.isPrivate() && !Stargate.canPrivate(player, portal)) {
            Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
            return;
        }
        if (destination.isOpen() && !destination.isAlwaysOn()) {
            Stargate.sendMessage((CommandSender)player, Stargate.getString("blockMsg"));
            return;
        }
        portal.open(player, false);
    }

    public static boolean hasPerm(Player player, String perm) {
        if (permDebug) {
            Stargate.debug("hasPerm::SuperPerm(" + player.getName() + ")", perm + " => " + player.hasPermission(perm));
        }
        return player.hasPermission(perm);
    }

    public static boolean hasPermDeep(Player player, String perm) {
        if (!player.isPermissionSet(perm)) {
            if (permDebug) {
                Stargate.debug("hasPermDeep::SuperPerm", perm + " => true");
            }
            return true;
        }
        if (permDebug) {
            Stargate.debug("hasPermDeep::SuperPerms", perm + " => " + player.hasPermission(perm));
        }
        return player.hasPermission(perm);
    }

    public static boolean canAccessWorld(Player player, String world) {
        if (Stargate.hasPerm(player, "stargate.use") || Stargate.hasPerm(player, "stargate.world")) {
            return Stargate.hasPermDeep(player, "stargate.world." + world);
        }
        return Stargate.hasPerm(player, "stargate.world." + world);
    }

    public static boolean canAccessNetwork(Player player, String network) {
        if (Stargate.hasPerm(player, "stargate.use") || Stargate.hasPerm(player, "stargate.network")) {
            return Stargate.hasPermDeep(player, "stargate.network." + network);
        }
        if (Stargate.hasPerm(player, "stargate.network." + network)) {
            return true;
        }
        String playerName = player.getName();
        if (playerName.length() > 11) {
            playerName = playerName.substring(0, 11);
        }
        return network.equals(playerName) && Stargate.hasPerm(player, "stargate.create.personal");
    }

    public static boolean canAccessServer(Player player, String server) {
        if (Stargate.hasPerm(player, "stargate.use") || Stargate.hasPerm(player, "stargate.servers")) {
            return Stargate.hasPermDeep(player, "stargate.server." + server);
        }
        return Stargate.hasPerm(player, "stargate.server." + server);
    }

    public static boolean canAccessPortal(Player player, Portal portal, boolean deny) {
        StargateAccessEvent event = new StargateAccessEvent(player, portal, deny);
        server.getPluginManager().callEvent((Event)event);
        return !event.getDeny();
    }

    public static boolean isFree(Player player, Portal src, Portal dest) {
        if (src.isFree()) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.use")) {
            return true;
        }
        return dest != null && !EconomyHandler.chargeFreeDestination && dest.isFree();
    }

    public static boolean canSee(Player player, Portal portal) {
        if (!portal.isHidden()) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.admin") || Stargate.hasPerm(player, "stargate.admin.hidden")) {
            return true;
        }
        return portal.isOwner(player);
    }

    public static boolean canPrivate(Player player, Portal portal) {
        if (portal.isOwner(player)) {
            return true;
        }
        return Stargate.hasPerm(player, "stargate.admin") || Stargate.hasPerm(player, "stargate.admin.private");
    }

    public static boolean canOption(Player player, String option) {
        if (Stargate.hasPerm(player, "stargate.option")) {
            return true;
        }
        return Stargate.hasPerm(player, "stargate.option." + option);
    }

    public static boolean canCreate(Player player, String network) {
        if (Stargate.hasPerm(player, "stargate.create")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.create.network")) {
            return Stargate.hasPermDeep(player, "stargate.create.network." + network);
        }
        return Stargate.hasPerm(player, "stargate.create.network." + network);
    }

    public static boolean canCreatePersonal(Player player) {
        if (Stargate.hasPerm(player, "stargate.create")) {
            return true;
        }
        return Stargate.hasPerm(player, "stargate.create.personal");
    }

    public static boolean canCreateGate(Player player, String gate) {
        if (Stargate.hasPerm(player, "stargate.create")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.create.gate")) {
            return Stargate.hasPermDeep(player, "stargate.create.gate." + gate);
        }
        return Stargate.hasPerm(player, "stargate.create.gate." + gate);
    }

    public static boolean canDestroy(Player player, Portal portal) {
        String network = portal.getNetwork();
        if (Stargate.hasPerm(player, "stargate.destroy")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.destroy.network")) {
            return Stargate.hasPermDeep(player, "stargate.destroy.network." + network);
        }
        if (Stargate.hasPerm(player, "stargate.destroy.network." + network)) {
            return true;
        }
        return portal.isOwner(player) && Stargate.hasPerm(player, "stargate.destroy.personal");
    }

    public static boolean chargePlayer(Player player, String target, int cost) {
        if (cost == 0) {
            return true;
        }
        if (!EconomyHandler.useEconomy()) {
            return true;
        }
        return EconomyHandler.chargePlayer(player, target, (double)cost);
    }

    public static boolean chargePlayer(Player player, UUID target, int cost) {
        if (cost == 0) {
            return true;
        }
        if (!EconomyHandler.useEconomy()) {
            return true;
        }
        return EconomyHandler.chargePlayer(player, target, (double)cost);
    }

    public static boolean chargePlayer(Player player, int cost) {
        if (cost == 0) {
            return true;
        }
        if (!EconomyHandler.useEconomy()) {
            return true;
        }
        return EconomyHandler.chargePlayer(player, cost);
    }

    public static int getUseCost(Player player, Portal src, Portal dest) {
        if (!EconomyHandler.useEconomy()) {
            return 0;
        }
        if (src.isFree()) {
            return 0;
        }
        if (dest != null && !EconomyHandler.chargeFreeDestination && dest.isFree()) {
            return 0;
        }
        if (src.getGate().getToOwner().booleanValue() && src.isOwner(player)) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.use")) {
            return 0;
        }
        return src.getGate().getUseCost();
    }

    public static int getCreateCost(Player player, Gate gate) {
        if (!EconomyHandler.useEconomy()) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.create")) {
            return 0;
        }
        return gate.getCreateCost();
    }

    public static int getDestroyCost(Player player, Gate gate) {
        if (!EconomyHandler.useEconomy()) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.destroy")) {
            return 0;
        }
        return gate.getDestroyCost();
    }

    private Plugin checkPlugin(String p) {
        Plugin plugin = this.pm.getPlugin(p);
        return this.checkPlugin(plugin);
    }

    private Plugin checkPlugin(Plugin plugin) {
        if (plugin != null && plugin.isEnabled()) {
            log.info("[Stargate] Found " + plugin.getDescription().getName() + " (v" + plugin.getDescription().getVersion() + ")");
            return plugin;
        }
        return null;
    }

    public static String replaceVars(String format, String[] search, String[] replace) {
        if (search.length != replace.length) {
            return "";
        }
        for (int i = 0; i < search.length; ++i) {
            format = format.replace(search[i], replace[i]);
        }
        return format;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = command.getName();
        if (cmd.equalsIgnoreCase("sg")) {
            Object p;
            if (args.length != 1) {
                return false;
            }
            if (args[0].equalsIgnoreCase("about")) {
                sender.sendMessage("Stargate Plugin created by Drakia");
                if (!lang.getString("author").isEmpty()) {
                    sender.sendMessage("Language created by " + lang.getString("author"));
                }
                return true;
            }
            if (sender instanceof Player && !Stargate.hasPerm((Player)(p = (Player)sender), "stargate.admin") && !Stargate.hasPerm((Player)p, "stargate.admin.reload")) {
                Stargate.sendMessage(sender, "Permission Denied");
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                for (Portal p2 : activeList) {
                    p2.deactivate();
                }
                this.closeAllPortals();
                activeList.clear();
                openList.clear();
                managedWorlds.clear();
                Portal.clearGates();
                Gate.clearGates();
                boolean oldEnableBungee = enableBungee;
                this.loadConfig();
                this.loadGates();
                this.loadAllPortals();
                lang.setLang(langName);
                lang.reload();
                if (EconomyHandler.economyEnabled && EconomyHandler.economy == null && EconomyHandler.setupEconomy(this.pm) && EconomyHandler.economy != null) {
                    log.info("[Stargate] Vault v" + EconomyHandler.vault.getDescription().getVersion() + " found");
                }
                if (!EconomyHandler.economyEnabled) {
                    EconomyHandler.vault = null;
                    EconomyHandler.economy = null;
                }
                if (oldEnableBungee != enableBungee) {
                    if (enableBungee) {
                        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
                        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)new pmListener());
                    } else {
                        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this, "BungeeCord");
                        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
                    }
                }
                Stargate.sendMessage(sender, "Stargate reloaded");
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defNetwork = "central";
        destroyExplosion = false;
        maxGates = 0;
        langName = "en";
        destMemory = false;
        handleVehicles = true;
        sortLists = false;
        protectEntrance = false;
        enableBungee = true;
        verifyPortals = true;
        ignoreEntrance = false;
        debug = false;
        permDebug = false;
        openList = new ConcurrentLinkedQueue();
        activeList = new ConcurrentLinkedQueue();
        blockPopulatorQueue = new LinkedList<BloxPopulator>();
        bungeeQueue = new HashMap<String, String>();
        managedWorlds = new HashSet();
    }

    private class SGThread
    implements Runnable {
        private SGThread() {
        }

        @Override
        public void run() {
            Portal p;
            long time = System.currentTimeMillis() / 1000L;
            Iterator<Portal> iter = openList.iterator();
            while (iter.hasNext()) {
                p = iter.next();
                if (p.isAlwaysOn() || !p.isOpen() || time <= p.getOpenTime() + 10L) continue;
                p.close(false);
                iter.remove();
            }
            iter = activeList.iterator();
            while (iter.hasNext()) {
                p = iter.next();
                if (!p.isActive() || time <= p.getOpenTime() + 10L) continue;
                p.deactivate();
                iter.remove();
            }
        }
    }

    private class BlockPopulatorThread
    implements Runnable {
        private BlockPopulatorThread() {
        }

        @Override
        public void run() {
            long sTime = System.nanoTime();
            while (System.nanoTime() - sTime < 25000000L) {
                BloxPopulator b = blockPopulatorQueue.poll();
                if (b == null) {
                    return;
                }
                Block blk = b.getBlox().getBlock();
                blk.setType(b.getMat(), false);
                if (b.getMat() == Material.END_GATEWAY && blk.getWorld().getEnvironment() == World.Environment.THE_END) {
                    EndGateway gateway = (EndGateway)blk.getState();
                    gateway.setExitLocation(blk.getWorld().getSpawnLocation());
                    gateway.setExactTeleport(true);
                    gateway.update(false, false);
                    continue;
                }
                if (b.getAxis() == null) continue;
                Orientable orientable = (Orientable)blk.getBlockData();
                orientable.setAxis(b.getAxis());
                blk.setBlockData((BlockData)orientable);
            }
        }
    }

    private class sListener
    implements Listener {
        private sListener() {
        }

        @EventHandler
        public void onPluginEnable(PluginEnableEvent event) {
            if (EconomyHandler.setupEconomy(Stargate.this.getServer().getPluginManager())) {
                log.info("[Stargate] Vault v" + EconomyHandler.vault.getDescription().getVersion() + " found");
            }
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().equals(EconomyHandler.vault)) {
                log.info("[Stargate] Vault plugin lost.");
            }
        }
    }

    private class eListener
    implements Listener {
        private eListener() {
        }

        @EventHandler
        public void onEntityExplode(EntityExplodeEvent event) {
            if (event.isCancelled()) {
                return;
            }
            for (Block b : event.blockList()) {
                Portal portal = Portal.getByBlock(b);
                if (portal == null) continue;
                if (destroyExplosion) {
                    portal.unregister(true);
                    continue;
                }
                event.setCancelled(true);
                break;
            }
        }
    }

    private class wListener
    implements Listener {
        private wListener() {
        }

        @EventHandler
        public void onWorldLoad(WorldLoadEvent event) {
            if (!managedWorlds.contains(event.getWorld().getName()) && Portal.loadAllGates(event.getWorld())) {
                managedWorlds.add(event.getWorld().getName());
            }
        }

        @EventHandler
        public void onWorldUnload(WorldUnloadEvent event) {
            Stargate.debug("onWorldUnload", "Reloading all Stargates");
            World w = event.getWorld();
            if (managedWorlds.contains(w.getName())) {
                managedWorlds.remove(w.getName());
                Portal.clearGates();
                for (World world : server.getWorlds()) {
                    if (!managedWorlds.contains(world.getName())) continue;
                    Portal.loadAllGates(world);
                }
            }
        }
    }

    private class bListener
    implements Listener {
        private bListener() {
        }

        @EventHandler
        public void onSignChange(SignChangeEvent event) {
            if (event.isCancelled()) {
                return;
            }
            Player player = event.getPlayer();
            Block block = event.getBlock();
            if (!(block.getBlockData() instanceof WallSign)) {
                return;
            }
            final Portal portal = Portal.createPortal(event, player);
            if (portal == null) {
                return;
            }
            Stargate.sendMessage((CommandSender)player, Stargate.getString("createMsg"), false);
            Stargate.debug("onSignChange", "Initialized stargate: " + portal.getName());
            server.getScheduler().scheduleSyncDelayedTask((Plugin)stargate, new Runnable(){

                @Override
                public void run() {
                    portal.drawSign();
                }
            }, 1L);
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onBlockBreak(BlockBreakEvent event) {
            if (event.isCancelled()) {
                return;
            }
            Block block = event.getBlock();
            Player player = event.getPlayer();
            Portal portal = Portal.getByBlock(block);
            if (portal == null && protectEntrance) {
                portal = Portal.getByEntrance(block);
            }
            if (portal == null) {
                return;
            }
            boolean deny = false;
            String denyMsg = "";
            if (!Stargate.canDestroy(player, portal)) {
                denyMsg = "Permission Denied";
                deny = true;
                log.info("[Stargate] " + player.getName() + " tried to destroy gate");
            }
            int cost = Stargate.getDestroyCost(player, portal.getGate());
            StargateDestroyEvent dEvent = new StargateDestroyEvent(portal, player, deny, denyMsg, cost);
            server.getPluginManager().callEvent((Event)dEvent);
            if (dEvent.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (dEvent.getDeny()) {
                Stargate.sendMessage((CommandSender)player, dEvent.getDenyReason());
                event.setCancelled(true);
                return;
            }
            cost = dEvent.getCost();
            if (cost != 0) {
                if (!Stargate.chargePlayer(player, cost)) {
                    Stargate.debug("onBlockBreak", "Insufficient Funds");
                    Stargate.sendMessage((CommandSender)player, Stargate.getString("inFunds"));
                    event.setCancelled(true);
                    return;
                }
                if (cost > 0) {
                    String deductMsg = Stargate.getString("ecoDeduct");
                    deductMsg = Stargate.replaceVars(deductMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(cost), portal.getName()});
                    Stargate.sendMessage((CommandSender)player, deductMsg, false);
                } else if (cost < 0) {
                    String refundMsg = Stargate.getString("ecoRefund");
                    refundMsg = Stargate.replaceVars(refundMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(-cost), portal.getName()});
                    Stargate.sendMessage((CommandSender)player, refundMsg, false);
                }
            }
            portal.unregister(true);
            Stargate.sendMessage((CommandSender)player, Stargate.getString("destroyMsg"), false);
        }

        @EventHandler
        public void onBlockPhysics(BlockPhysicsEvent event) {
            Block block = event.getBlock();
            Portal portal = null;
            if (block.getType() == Material.NETHER_PORTAL) {
                portal = Portal.getByEntrance(block);
            } else if (Tag.BUTTONS.isTagged((Keyed)block.getType())) {
                portal = Portal.getByControl(block);
            }
            if (portal != null) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onBlockFromTo(BlockFromToEvent event) {
            Portal portal = Portal.getByEntrance(event.getBlock());
            if (portal != null) {
                event.setCancelled(event.getBlock().getY() == event.getToBlock().getY());
            }
        }

        @EventHandler
        public void onPistonExtend(BlockPistonExtendEvent event) {
            for (Block block : event.getBlocks()) {
                Portal portal = Portal.getByBlock(block);
                if (portal == null) continue;
                event.setCancelled(true);
                return;
            }
        }

        @EventHandler
        public void onPistonRetract(BlockPistonRetractEvent event) {
            if (!event.isSticky()) {
                return;
            }
            for (Block block : event.getBlocks()) {
                Portal portal = Portal.getByBlock(block);
                if (portal == null) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    private class pListener
    implements Listener {
        private pListener() {
        }

        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            if (!enableBungee) {
                return;
            }
            Player player = event.getPlayer();
            String destination = bungeeQueue.remove(player.getName().toLowerCase());
            if (destination == null) {
                return;
            }
            Portal portal = Portal.getBungeeGate(destination);
            if (portal == null) {
                Stargate.debug("PlayerJoin", "Error fetching destination portal: " + destination);
                return;
            }
            portal.teleport(player, portal, null);
        }

        @EventHandler
        public void onPlayerTeleport(PlayerTeleportEvent event) {
            PlayerTeleportEvent.TeleportCause cause = event.getCause();
            if (!event.isCancelled() && (cause == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || cause == PlayerTeleportEvent.TeleportCause.END_GATEWAY && World.Environment.THE_END == event.getFrom().getWorld().getEnvironment()) && Portal.getByAdjacentEntrance(event.getFrom()) != null) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        public void onPlayerMove(PlayerMoveEvent event) {
            if (event.isCancelled()) {
                return;
            }
            if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
                return;
            }
            Player player = event.getPlayer();
            Portal portal = Portal.getByEntrance(event.getTo());
            if (portal == null || !portal.isOpen()) {
                return;
            }
            if (!portal.isOpenFor(player)) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
                portal.teleport(player, portal, event);
                return;
            }
            Portal destination = portal.getDestination(player);
            if (!portal.isBungee() && destination == null) {
                return;
            }
            boolean deny = false;
            if (portal.isBungee()) {
                if (!Stargate.canAccessServer(player, portal.getNetwork())) {
                    deny = true;
                }
            } else {
                if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                    deny = true;
                }
                if (!Stargate.canAccessWorld(player, destination.getWorld().getName())) {
                    deny = true;
                }
            }
            if (!Stargate.canAccessPortal(player, portal, deny)) {
                Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
                portal.teleport(player, portal, event);
                portal.close(false);
                return;
            }
            int cost = Stargate.getUseCost(player, portal, destination);
            if (cost > 0) {
                Player p;
                boolean success = portal.getGate().getToOwner().booleanValue() ? (portal.getOwnerUUID() == null ? Stargate.chargePlayer(player, portal.getOwnerUUID(), cost) : Stargate.chargePlayer(player, portal.getOwnerName(), cost)) : Stargate.chargePlayer(player, cost);
                if (!success) {
                    Stargate.sendMessage((CommandSender)player, Stargate.getString("inFunds"));
                    portal.close(false);
                    return;
                }
                String deductMsg = Stargate.getString("ecoDeduct");
                deductMsg = Stargate.replaceVars(deductMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(cost), portal.getName()});
                Stargate.sendMessage((CommandSender)player, deductMsg, false);
                if (portal.getGate().getToOwner().booleanValue() && portal.getOwnerUUID() != null && (p = portal.getOwnerUUID() != null ? server.getPlayer(portal.getOwnerUUID()) : server.getPlayer(portal.getOwnerName())) != null) {
                    String obtainedMsg = Stargate.getString("ecoObtain");
                    obtainedMsg = Stargate.replaceVars(obtainedMsg, new String[]{"%cost%", "%portal%"}, new String[]{EconomyHandler.format(cost), portal.getName()});
                    Stargate.sendMessage((CommandSender)p, obtainedMsg, false);
                }
            }
            Stargate.sendMessage((CommandSender)player, Stargate.getString("teleportMsg"), false);
            if (portal.isBungee()) {
                if (!enableBungee) {
                    player.sendMessage(Stargate.getString("bungeeDisabled"));
                    portal.close(false);
                    return;
                }
                portal.teleport(player, portal, event);
                try {
                    String msg = event.getPlayer().getName() + "#@#" + portal.getDestinationName();
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    DataOutputStream msgData = new DataOutputStream(bao);
                    msgData.writeUTF("Forward");
                    msgData.writeUTF(portal.getNetwork());
                    msgData.writeUTF("SGBungee");
                    msgData.writeShort(msg.length());
                    msgData.writeBytes(msg);
                    player.sendPluginMessage((Plugin)stargate, "BungeeCord", bao.toByteArray());
                }
                catch (IOException ex) {
                    log.severe("[Stargate] Error sending BungeeCord teleport packet");
                    ex.printStackTrace();
                    return;
                }
                try {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    DataOutputStream msgData = new DataOutputStream(bao);
                    msgData.writeUTF("Connect");
                    msgData.writeUTF(portal.getNetwork());
                    player.sendPluginMessage((Plugin)stargate, "BungeeCord", bao.toByteArray());
                    bao.reset();
                }
                catch (IOException ex) {
                    log.severe("[Stargate] Error sending BungeeCord connect packet");
                    ex.printStackTrace();
                    return;
                }
                portal.close(false);
                return;
            }
            destination.teleport(player, portal, event);
            portal.close(false);
        }

        @EventHandler
        public void onPlayerInteract(PlayerInteractEvent event) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (block.getBlockData() instanceof WallSign) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    event.setUseItemInHand(Event.Result.DENY);
                    event.setUseInteractedBlock(Event.Result.DENY);
                    boolean deny = false;
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        deny = true;
                    }
                    if (!Stargate.canAccessPortal(player, portal, deny)) {
                        Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
                        return;
                    }
                    if (!portal.isOpen() && !portal.isFixed()) {
                        portal.cycleDestination(player);
                    }
                    return;
                }
                if (Tag.BUTTONS.isTagged((Keyed)block.getType())) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    event.setUseItemInHand(Event.Result.DENY);
                    event.setUseInteractedBlock(Event.Result.DENY);
                    boolean deny = false;
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        deny = true;
                    }
                    if (!Stargate.canAccessPortal(player, portal, deny)) {
                        Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
                        return;
                    }
                    Stargate.openPortal(player, portal);
                    if (portal.isOpenFor(player)) {
                        event.setUseInteractedBlock(Event.Result.ALLOW);
                    }
                }
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK && block.getBlockData() instanceof WallSign) {
                Portal portal = Portal.getByBlock(block);
                if (portal == null) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    event.setCancelled(true);
                }
                boolean deny = false;
                if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                    deny = true;
                }
                if (!Stargate.canAccessPortal(player, portal, deny)) {
                    Stargate.sendMessage((CommandSender)player, Stargate.getString("denyMsg"));
                    return;
                }
                if (!portal.isOpen() && !portal.isFixed()) {
                    portal.cycleDestination(player, -1);
                }
            }
        }
    }

    private class vListener
    implements Listener {
        private vListener() {
        }

        @EventHandler
        public void onVehicleMove(VehicleMoveEvent event) {
            if (!handleVehicles) {
                return;
            }
            List passengers = event.getVehicle().getPassengers();
            Vehicle vehicle = event.getVehicle();
            Portal portal = Portal.getByEntrance(event.getTo());
            if (portal == null || !portal.isOpen()) {
                return;
            }
            if (portal.isBungee()) {
                return;
            }
            if (passengers.isEmpty() || !(passengers.get(0) instanceof Player)) {
                Portal dest = portal.getDestination();
                if (dest == null) {
                    return;
                }
                dest.teleport(vehicle);
            }
        }
    }
}

